/**CHeaderFile*****************************************************************

  FileName    [mc.h]

  PackageName [mc]

  Synopsis    [Fair CTL model checking algorithms. External header file.]

  Description [Fair CTL model checking algorithms. External header file.]

  Author      [Marco Roveri]

  Revision    [$Id: $]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#ifndef _MC
#define _MC

#include "util.h"
#include "dd.h"

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

void Mc_Init ARGS((void));
void Mc_End ARGS((void));

int  check_spec ARGS((node_ptr));
void check_compute ARGS((node_ptr));
void check_transition_relation ARGS((void));
void check_invar ARGS((node_ptr));
void check_invar_fb ARGS((node_ptr));
void check_invar_strong ARGS((node_ptr));
void check_after ARGS((node_ptr));
void print_spec  ARGS((FILE *file, node_ptr n));
void print_invar ARGS((FILE *file, node_ptr n));
void print_compute ARGS((FILE *, node_ptr));
void reset_trace_number ARGS((void));
bdd_ptr  compute_fair_states      ARGS((void));
void     compute_reachable_states ARGS((void));
/* Yuan Lu */
bdd_ptr  compute_reachable_states_while_check ARGS((bdd_ptr));
bdd_ptr  ex      ARGS((bdd_ptr));
bdd_ptr  ef      ARGS((bdd_ptr));
bdd_ptr  eg      ARGS((bdd_ptr));
bdd_ptr  eu      ARGS((bdd_ptr, bdd_ptr));
bdd_ptr  au      ARGS((bdd_ptr, bdd_ptr));
bdd_ptr  ebu     ARGS((bdd_ptr, bdd_ptr, int, int));
bdd_ptr  abu     ARGS((bdd_ptr, bdd_ptr, int, int));
bdd_ptr  ebf     ARGS((bdd_ptr, int, int));
bdd_ptr  ebg     ARGS((bdd_ptr, int, int));
int      minu    ARGS((bdd_ptr, bdd_ptr));
int      maxu    ARGS((bdd_ptr, bdd_ptr));
node_ptr explain ARGS((node_ptr, node_ptr, node_ptr));
node_ptr ex_explain ARGS((node_ptr p, bdd_ptr f));
bdd_ptr  eval_spec      ARGS((node_ptr, node_ptr));
node_ptr eval_formula_list ARGS((node_ptr, node_ptr));
int      eval_compute   ARGS((node_ptr, node_ptr));
int      check_AG_only  ARGS((node_ptr, node_ptr));
/* Yuan Lu */
int      check_AG_step  ARGS((node_ptr, node_ptr));
node_ptr make_AG_counterexample ARGS((node_ptr l, bdd_ptr s0));
void     compute_plan                ARGS((bdd_ptr, node_ptr, int, int));
void     check_invariant_forward     ARGS((node_ptr));
void     check_invariant_forward_opt ARGS((node_ptr));
void     compute_plan_fb             ARGS((bdd_ptr, bdd_ptr, node_ptr, int, bdd_ptr, node_ptr, int));
void     temporal_projection         ARGS((node_ptr, node_ptr));
void     eval_after                  ARGS((node_ptr, bdd_ptr *));
void     check_invariant_strong      ARGS((node_ptr));
void     check_invariant_forward_backward    ARGS((node_ptr));
void     check_invariant_forward_backward_op ARGS((node_ptr));
bdd_ptr  trans_is_total                      ARGS((void));
void     print_explanation           ARGS((node_ptr));
void     print_reachable_states      ARGS((void));

void     init_traces_hash      ARGS((void));
void     insert_traces_hash    ARGS((node_ptr, node_ptr));
node_ptr lookup_traces_hash    ARGS((node_ptr));
void     clear_traces_hash     ARGS((void));

#endif /* _mc */
