/**CHeaderFile*****************************************************************

  FileName    [ltlInt.h]

  PackageName [ltl]

  Synopsis    [Internal header of the <tt>ltl</tt> package.]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _LTL_INT
#define _LTL_INT

#include <stdlib.h>
#include <stdio.h>
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "mc.h"
#include "img.h"
#include "opt.h"
#include "cmd.h"

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
EXTERN add_ptr input_variables_add;
EXTERN bdd_ptr input_variables_bdd;
EXTERN add_ptr next_input_variables_add;
EXTERN bdd_ptr next_input_variables_bdd;
EXTERN add_ptr state_variables_add;
EXTERN bdd_ptr state_variables_bdd;
EXTERN add_ptr next_state_variables_add;
EXTERN bdd_ptr next_state_variables_bdd;
EXTERN node_ptr state_variables;
EXTERN node_ptr input_variables;
EXTERN node_ptr all_symbols;
EXTERN node_ptr all_variables;
EXTERN options_ptr options;
EXTERN cmp_struct_ptr cmps;
EXTERN bdd_ptr trans_bdd;
EXTERN bdd_ptr fair_states_bdd;
EXTERN node_ptr fairness_constraints_bdd;
EXTERN node_ptr real_state_variables;
EXTERN FILE * nusmv_stdout;
EXTERN FILE * nusmv_stderr;
EXTERN DdManager * dd_manager;
EXTERN bdd_ptr invar_bdd;
EXTERN bdd_ptr init_bdd;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

void check_ltlspec ARGS((node_ptr ltl_spec));

#endif /* _LTL_INT */
