/* ltl spec_formula */

%{
#include <stdio.h>
#include "l2s.h"

extern node *Specf;      /* spec formula */
extern char yytext[];

%}
%expect 96
%start ltlformula

%token OR AND IMPLY EQUIV NEG
%token FUTURE GLOBAL UNTIL NEXT
%token PLUS MINUS TIMES DIVIDE MOD EQUAL LE GE LT GT UNION SETIN UMINUS
%token ATOM NUMBER

%left  IMPLY EQUIV
%left  OR 
%left  AND
%left  NEG 
%left  NEXT FUTURE GLOBAL UNTIL 
%left  UNION
%left  SETIN
%left  MOD
%left  PLUS MINUS
%left  TIMES DIVIDE
%left  UMINUS		/* supplies precedence for unary minus */

%union  {
  node *node_ptr;
  char *str_ptr;
      }
%type  <node_ptr>  ltlf orexpr andexpr atomexpr  untilexpr
%type  <str_ptr>   term number constant neatomset smvexpr NUMBER

%%

ltlformula : ltlf {Specf = $1;}
           ;
ltlf       : orexpr {$$ = $1;}
           | ltlf IMPLY orexpr {$$ = gen_node('>',$1,$3);}
           | ltlf EQUIV orexpr {$$ = gen_node('=',$1,$3);}
           ;
orexpr     : andexpr {$$ = $1;}
           | orexpr OR andexpr {$$ = gen_node('|',$1,$3);}
           ;
andexpr    : untilexpr {$$ = $1;}
           | andexpr AND untilexpr {$$ = gen_node('&',$1,$3);}
           ;
untilexpr  : atomexpr {$$ = $1;}
           | untilexpr UNTIL atomexpr {$$ = gen_node('U',$1,$3);}
           ;
atomexpr   : NEG atomexpr {$$ = gen_node('!',$2,NULL);}
           | NEXT atomexpr {$$ = gen_node('X',$2,NULL);}
           | GLOBAL atomexpr {$$ = gen_node('G',$2,NULL);}
           | FUTURE atomexpr {$$ = gen_node('F',$2,NULL);}
           | '(' ltlf ')' {$$ = $2;}
           | smvexpr {$$ = gen_leaf($1);}
           ;

term       : ATOM {$$ = mycpy(yytext);}
           | term '[' smvexpr ']' {$$ = mystrconcat4($1,"[",$3,"]");}
           ;

number     : NUMBER {$$ = mycpy(yytext);}
	   | PLUS NUMBER %prec UMINUS
	     { $$ = mystrconcat2("+",$2);}
           | MINUS NUMBER %prec UMINUS
	     { $$ = mystrconcat2("-",$2);}
           ;

constant   : ATOM {$$ = mycpy(yytext);}
           | number {$$ = $1;}
           ;

neatomset  : constant
           | neatomset ',' constant {$$ = mystrconcat3($1,",",$3);}
           ; 

smvexpr    : term {$$ = $1;}
           | number {$$ = $1;}
           | '(' smvexpr ')' {$$ = mystrconcat3("(",$2,")");}
           | smvexpr PLUS smvexpr { $$ = mystrconcat3($1,"+",$3); }
           | smvexpr MINUS smvexpr { $$ = mystrconcat3($1,"-",$3); }
           | smvexpr TIMES smvexpr { $$ = mystrconcat3($1,"*",$3); }
           | smvexpr DIVIDE smvexpr { $$ = mystrconcat3($1,"/",$3); }
           | smvexpr MOD smvexpr { $$ = mystrconcat3($1,"mod",$3); }
           | smvexpr EQUAL smvexpr { $$ = mystrconcat3($1,"=",$3); }
           | smvexpr LT smvexpr { $$ = mystrconcat3($1,"<",$3); }
           | smvexpr GT smvexpr { $$ = mystrconcat3($1,">",$3); }
           | smvexpr LE smvexpr { $$ = mystrconcat3($1,"<=",$3); }
           | smvexpr GE smvexpr { $$ = mystrconcat3($1,">=",$3); }
           | '{' neatomset '}' { $$ = mystrconcat3("{",$2,"}"); } 
           | smvexpr UNION smvexpr { $$ = mystrconcat3($1,"union",$3); }
           | smvexpr SETIN smvexpr { $$ = mystrconcat3($1,"in",$3); }
           ;

%%
#if 0
#include "lex.yy.c"
#endif
char *mystrconcat2(char *s1, char *s2)
{
  char *ret;
  int len;
  len = strlen(s1);
  len += strlen(s2);
  ret = (char *)malloc(sizeof(char)*(len+1));
  strcpy(ret,s1);
  strcat(ret,s2);
  return(ret);
}

char *mystrconcat3(char *s1, char *s2, char *s3)
{
  char *ret;
  int len;
  len = strlen(s1);
  len += strlen(s2);
  len += strlen(s3);
  ret = (char*)malloc(sizeof(char)*(len+3));
  strcpy(ret,s1);
  strcat(ret," ");
  strcat(ret,s2);
  strcat(ret," ");
  strcat(ret,s3);
  return(ret);
}

char *mystrconcat4(char *s1, char *s2, char *s3, char *s4)
{
  char *ret;
  int len;
  len = strlen(s1);
  len += strlen(s2);
  len += strlen(s3);
  len += strlen(s4);
  ret = (char*)malloc(sizeof(char)*(len+1));
  strcpy(ret,s1);
  strcat(ret,s2);
  strcat(ret,s3);
  strcat(ret,s4);
  return(ret);
}

node *mymalloc_node(void)
{
  node *ret;
  ret = (node *)Mymalloc(sizeof(node));
  ret -> str = (char *)NULL;
  ret -> op = (char)NULL;
  ret -> el = (char *)NULL;
  ret -> pel = (char *)NULL;
  ret -> flag = 0;
  ret -> left = (node *)NULL;
  ret -> right = (node *)NULL;
  return(ret);
}

node *gen_node(char op, node *left, node *right)
{
  node *ret;
  ret = mymalloc_node();
  ret -> op = op;
  ret -> left = left;
  ret -> right = right;
  return(ret);
}

node *gen_leaf(char *str)
{
  node *ret;
  ret = mymalloc_node();
  ret -> op = 'l';
  ret -> str = mystrconcat3("(",str,")");
  return (ret);
}

char *mycpy(char *text)
{
  char *cptr;
  cptr = (char *) Mymalloc(strlen(text) + 1);
  /*  printf("string = %s, length = %d\n", text,strlen(text)); */
  strcpy(cptr, text);
  return(cptr);
}

void yyerror(char *msg)
{
  (void) fprintf(stderr, "%s\n", msg);
  (void) fprintf(stderr, "%s : Line %d\n", yytext, get_linenumber());
  /* exit(1); */
}

int yywrap(void)
{
  return(1);
}
