%{
#include <stdio.h>
#include "l2s.h"
#include "parser.h"

extern void inc_linenumber();
%}

W    [ \t]
L    [\n]
  
%%
{W}+          ;
{L}           {inc_linenumber();}
"|"           return OR;
"&"           return AND;
"->"          return IMPLY;
"<->"         return EQUIV;
"!"           return NEG; 
"X"           return NEXT;
"F"           return FUTURE;
"G"           return GLOBAL;
"U"           return UNTIL;
"+"           return PLUS;
"-"           return MINUS;
"*"           return TIMES;
"/"           return DIVIDE;
"mod"         return MOD;
"="           return EQUAL;
"<="          return LE;
">="          return GE;
"<"           return LT;
">"           return GT;
"union"       return UNION;
"in"          return SETIN;
[A-Za-z_][A-Za-z0-9_.\$#-]*  return ATOM;
[0-9]+        return NUMBER;
.             return yytext[0];
