#ifndef _l2s_h_
#define _l2s_h_
typedef struct node_struct {
  char *str;
  char op;
  char *el;
  char *pel;
  int flag; 
  struct node_struct *left;
  struct node_struct *right;
} node;

typedef struct str_list_struct{
  char *name;
  char *str;
  struct str_list_struct *next;
} str_list;

typedef struct output_list_struct{
  char *key;
  char *item;
  struct output_list_struct *next;
} output_list;

int get_linenumber(void);
void inc_linenumber(void);
char *Mymalloc(unsigned size);
output_list *mymalloc_output_list(void);
char *itoa(int num);
void initbit(void);
void print_node(FILE * ofile, node * t);
void print_formula(FILE * ofile, node *t);
char *shortitob(long num);
char *itob(int num);
node *expand_formula(node *t);
char *op_string(char *op, char *str1, char *str2);
char *gen_name_number(int n);
int str_hash_func(char *s);
str_list *mymalloc_str_list(void);
void add_var_list(char *key, char *item);
str_list *mymalloc_str_list(void);
void add_var_list(char *key, char *item);
char *reg_var(char *str);
char *formula_string(node *t);
char *gen_next_term(char *s);
output_list *search_list(output_list *list, char *s);
int define_check(char *s);
void add_define_list(char *lit, char *s);
int next_check(char *s);
void add_next_list(char *lit, char *s);
int fairness_check(char *s);
void add_fairness_list(char *lit, char *s);
char *get_plit(node *t);
void set_node(node *t);
void init_str_hash(void );
void remove_outer_par(char *s);
void print_smv_format(FILE * ofile);
void set_information(node *t);
node *reduce_formula(node *t);

int yywrap(void);
void yyerror(char *msg);
char *mycpy(char *text);
node *gen_leaf(char *str);
node *gen_node(char op, node *left, node *right);
node *mymalloc_node(void);
char *mystrconcat4(char *s1, char *s2, char *s3, char *s4);
char *mystrconcat3(char *s1, char *s2, char *s3);
char *mystrconcat2(char *s1, char *s2);

#endif
