/**CFile***********************************************************************

  FileName    [imgUtil.c]

  PackageName [img]

  Synopsis    [High-level routines to perform image computations.]

  Description [This file provides the interface to the method-specific
  image computation routines.]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "imgInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Computes the backward image of a set of states.]

  Description        [Computes the backward image of a set of states.
  The resulting set is in term of current state variables. Depending
  the partitioning heuristich choosen, the corresponding image
  function is used.]

  SideEffects        [None]

  SeeAlso            [Img_ImageFwd]

******************************************************************************/
bdd_ptr Img_ImageBwd(bdd_ptr g)
{
  if (opt_monolithic(options)) return(ImgImageBwdMonolithic(g));
  else if (opt_conj_partitioning(options)) return(ImgImageBwdConjunctive(g));
  else if (opt_disj_partitioning(options)) return(ImgImageBwdDisjunctive(g));
  else if (opt_iwls95cp_partitioning(options)) return(ImgImageBwdIwls95(g));
  else rpterr("Img_ImageBwd: partitioning method not available.");
}

/**Function********************************************************************

  Synopsis           [Computes the forward image of a set of states.]

  Description        [Computes the forward image of a set of states.
  The resulting set is in term of current state variables. Depending
  the partitioning heuristich choosen, the corresponding image
  function is used.]

  SideEffects        [None]

  SeeAlso            [Img_ImageBwd]

******************************************************************************/
bdd_ptr Img_ImageFwd(bdd_ptr g)
{
  if (opt_monolithic(options)) return(ImgImageFwdMonolithic(g));
  else if (opt_conj_partitioning(options)) return(ImgImageFwdConjunctive(g));
  else if (opt_disj_partitioning(options)) return(ImgImageFwdDisjunctive(g));
  else if (opt_iwls95cp_partitioning(options)) return(ImgImageFwdIwls95(g));
  else rpterr("Img_ImageFwd: partitioning method not available.");
}

/**Function********************************************************************

  Synopsis           [required]

  Description        [Return zero if something wrong.]

  SideEffects        [required]

  SeeAlso            [optional]

******************************************************************************/
int Img_Check(){
  if (opt_monolithic(options)) {
    if (trans_bdd == (bdd_ptr)NULL) return(0);
  } else {
    if (opt_conj_partitioning(options)) {
      if (cp_trans_bdd == Nil) return(0);
    } else {
      if (opt_disj_partitioning(options)) {
        if (dp_trans_bdd == Nil) return(0);
      } else {
        if (opt_iwls95cp_partitioning(options)) {
          if ((Iwls95_Fwd_trans == Nil) || (Iwls95_Bwd_trans == Nil)) return(0);
        }
      }
    }
  }
  return(1);
}
