/**CHeaderFile*****************************************************************

  FileName    [imgInt.h]

  PackageName [img]

  Synopsis    [Internal declarations for img package]

  Description []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _IMGINT
#define _IMGINT

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "compile.h"
#include "opt.h"
#include "img.h" 
#include "cmd.h"

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

EXTERN options_ptr options;

EXTERN node_ptr forward_quantifiers_bdd;
EXTERN node_ptr reverse_quantifiers_bdd;
EXTERN node_ptr cp_trans_bdd;
EXTERN node_ptr dp_trans_bdd;
EXTERN node_ptr Iwls95_Fwd_trans;
EXTERN node_ptr Iwls95_Bwd_trans;
EXTERN node_ptr state_variables;

EXTERN DdManager * dd_manager;
EXTERN bdd_ptr trans_bdd;
EXTERN bdd_ptr next_state_variables_bdd;
EXTERN bdd_ptr state_variables_bdd;
EXTERN bdd_ptr input_variables_bdd;
EXTERN bdd_ptr next_input_variables_bdd;
EXTERN bdd_ptr reachable_states_bdd;

EXTERN FILE * nusmv_stdout;
EXTERN FILE * nusmv_stderr;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN bdd_ptr ImgImageBwdConjunctive ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageFwdConjunctive ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageBwdDisjunctive ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageFwdDisjunctive ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageBwdIwls95 ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageFwdIwls95 ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageBwdMonolithic ARGS((bdd_ptr g));
EXTERN bdd_ptr ImgImageFwdMonolithic ARGS((bdd_ptr g));
EXTERN bdd_ptr Iwls95ImageFwd ARGS((DdManager *dd, node_ptr Clist, bdd_ptr S, bdd_ptr vars));
EXTERN bdd_ptr Iwls95ImageBwd ARGS((DdManager *dd, node_ptr Clist, bdd_ptr S, bdd_ptr vars));
EXTERN bdd_ptr Iwls95ImageBoth  ARGS((DdManager *dd, node_ptr Clist, bdd_ptr S, bdd_ptr vars));

#endif /* _IMGINT */
