/**CFile***********************************************************************

  FileName    [imgConj.c]

  PackageName [img]

  Synopsis    [Routines for image computation using a conjunctively
  decomposed transition relation.]

  Description [Routines for image computation using a conjunctively
  decomposed transition relation.]

  SeeAlso     [imgIwls95.c, imgMono.c, imgDisj.c]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "imgInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Computes the backward image of a set of states.]

  Description        [Computes the backward image of a set of
  states. It uses a implicitly conjoined transtion relation. The
  resulting set is in term of current state variables.]

  SideEffects        [None]

  SeeAlso            [ImgImageFwdConjunctive]

******************************************************************************/
bdd_ptr ImgImageBwdConjunctive(bdd_ptr g)
{
  bdd_ptr acc, tmp_1;
  node_ptr t_r_c = cp_trans_bdd;
  node_ptr q = reverse_quantifiers_bdd;
  
  acc = bdd_shift_forward(dd_manager, g);
  while(t_r_c){
    bdd_ptr cur_cube = (bdd_ptr)car(q);

    if (opt_verbose_level_gt(options, 0))
      fprintf(stderr,"relational product: size of acc = %d\n",
              bdd_size(dd_manager, acc));
    tmp_1 = bdd_forsome(dd_manager, acc, cur_cube);
    bdd_free(dd_manager, acc);
    acc = bdd_and(dd_manager, tmp_1, (bdd_ptr)car(t_r_c));
    bdd_free(dd_manager, tmp_1);
    if (reachable_states_bdd) {
      tmp_1 = bdd_simplify_assuming(dd_manager, acc, reachable_states_bdd);
      bdd_free(dd_manager, acc);
      acc = tmp_1;
    }
    t_r_c = cdr(t_r_c);
    q = cdr(q);
  }
  tmp_1 = bdd_forsome(dd_manager, acc, (bdd_ptr)car(q));
  bdd_free(dd_manager, acc);
  acc = tmp_1;
  return(acc);
}

/**Function********************************************************************

  Synopsis           [Computes the forward image of a set of states.]

  Description        [Computes the forward image of a set of
  states. It uses a implicitly conjoined transtion relation. The
  resulting set is in term of current state variables.]

  SideEffects        [None]

  SeeAlso            [ImgImageBwdConjunctive]

******************************************************************************/
bdd_ptr ImgImageFwdConjunctive(bdd_ptr g)
{
  bdd_ptr  acc, tmp_1;
  node_ptr t_r_c = cp_trans_bdd;
  node_ptr q = forward_quantifiers_bdd;
  
  acc = bdd_dup(g);
  while(t_r_c){
    bdd_ptr cur_cube = (bdd_ptr)car(q);
  
    if (opt_verbose_level_gt(options, 0))
      fprintf(stderr,"relational product: size of acc = %d\n",
              bdd_size(dd_manager, acc));
    tmp_1 = bdd_forsome(dd_manager, acc, cur_cube);
    bdd_free(dd_manager, acc);
    acc = bdd_and(dd_manager, tmp_1, (bdd_ptr)car(t_r_c));
    bdd_free(dd_manager, tmp_1);
    t_r_c = cdr(t_r_c);
    q = cdr(q);
  }
  tmp_1 = bdd_forsome(dd_manager, acc, (bdd_ptr)car(q));
  bdd_free(dd_manager, acc);
  acc = bdd_shift_backward(dd_manager, tmp_1);
  bdd_free(dd_manager, tmp_1);
  return(acc);
}
