/**CHeaderFile*****************************************************************

  FileName    [img.h]

  PackageName [img]

  Synopsis    [Methods for performing image computations.]

  Description [This package is used to compute the image (forward or
  backward) of a set. The problem of computing images is fundamental
  in many symbolic analisys techniques (reachability analisys, model
  checking of CTL formulas, ...). The "img" package offers the user an
  interface wich is independent from the techique choosen to represent
  the transition relation. 

  Actually four methods are offered to users:
  <ul>
  <li><b>Monolithic</b>: This is the most naive approach possible. A
       single relation <it>R(s,s')</it> is constructed during the compilation.</li>
  <li><b>Disjunctive</b>: The transition relation is decomposed in an
      implicit disjunction of transition relations. In this way,
      instead of performing the image computation by a relational
      product between big BDDs, we perform <it>n</it> (where
      <it>n</it> is the number of disjunct) relational proiduct
      between small BDDs (we use the distibution of existe among
      disjunction). This technique is useful when the model is
      completely asyncronous. </li>
  <li><b>Conjunctive</b>: The transition relation is decomposed in an
      implicit conjunction of transition relations (usually called
      clusters). This technique is based on the early quantification
      heuristic.
      <ul>
      <li><b>No heuristic</b>: In this method the clusters are built
          according to a given threshold. After the clustering the
          early quantification is performed.</li>
      <li><b>IWLS95</b>: In this method is an improvement of the
          above. First of all for each variable is constructed its
          transition function. Then these transitions (which are
          implicitly conjoined) are ordered according to the algorithm
          described in "Efficient BDD Algorithms for FSM Synthesis and
          Verification", by R. K. Ranjan et. al. in the proceedings of
          IWLS'95. After this ordering the transition relations are
          grouped together, making a cluster whenever the BDD size (number
          of BDD nodes) reaches a threshold. After the clustering,
          clusters are ordered according the IWLS95 algorithm. In this
          method the order of clusters is differente for forward and
          backward image computation, and the corresponding routines
          are called with the appropriate order of clustering and
          early quantification schedule.</li>
      </ul>
      </li>
  </ul>
  ]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _IMG
#define _IMG
/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
bdd_ptr Img_ImageBwd ARGS((bdd_ptr));
bdd_ptr Img_ImageFwd ARGS((bdd_ptr));
bdd_ptr Img_ImageFwdMonolithicOpt ARGS((bdd_ptr FromLowerBound, bdd_ptr FromUpperBound, bdd_ptr toCareSet));
bdd_ptr Img_ImageBwdMonolithicOpt ARGS((bdd_ptr FromLowerBound, bdd_ptr FromUpperBound, bdd_ptr toCareSet));
int     Img_Check    ARGS((void));

#endif /* _IMG */
