/**CFile***********************************************************************

  FileName    [smDebug.c]

  PackageName [sm]

  Synopsis    [Interface of the sm package with the shell.]

  Description [Interface of the sm package with the shell.]

  SeeAlso     []

  Author      [Yuan Lu]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/
#include "smInt.h"



void debug_print_node(node_ptr n)
{
  node_ptr nn;

  if(((unsigned)n)<1048576) return;
  switch(n->type) {
    case GOTO:
        printf("%x: GOTO\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
   case LET:
        printf("%x: LET\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
   case STEP:
        printf("%x: STEP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
   case EVAL:
        printf("%x: EVAL\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
   case RESET:
        printf("%x: RESET\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
   case ASYNC:
        printf("%x: ASYNC\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
   case ATOM:
	printf("%x: ATOM\t%s, 0\n", n, n->left.strtype->text);
	break;
    case MODULE:
	printf("%x: MODULE\t%x, %x\n", n, n->left.nodetype,
	       n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case MODTYPE:
	printf("%x: MODTYPE\t%x, %x\n", n, n->left.nodetype,
	       n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case LAMBDA:
        printf("%x: LAMBDA\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case CONTEXT:
        printf("%x: CONTEXT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case EU:
	printf("%x: EU\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case AU:
        printf("%x: AU\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case VAR:
        printf("%x: VAR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case DEFINE:
        printf("%x: DEFINE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case INIT:
        printf("%x: INIT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case TRANS:
        printf("%x: TRANS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case INVAR:
        printf("%x: INVAR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case SPEC:
        printf("%x: SPEC\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case COMPUTE:
        printf("%x: COMPUTE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case FAIRNESS:
        printf("%x: FAIRNESS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case ISA:
        printf("%x: ISA\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case CONSTANT:
        printf("%x: CONSTANT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case ASSIGN:
        printf("%x: ASSIGN\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case INPUT:
        printf("%x: INPUT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case OUTPUT:
        printf("%x: OUTPUT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case IMPLEMENTS:
        printf("%x: IMPLEMENTS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case BOOLEAN:
        printf("%x: BOOLEAN\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case ARRAY:
        printf("%x: ARRAY\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case OF:
        printf("%x: OF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case SCALAR:
        printf("%x: SCALAR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case CONS:
        printf("%x: CONS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case OVER:
        printf("%x: OVER\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case BDD:
        printf("%x: BDD\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case EQDEF:
        printf("%x: EQDEF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case FALSEEXP:
        printf("%x: FALSEEXP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case TRUEEXP:
        printf("%x: TRUEEXP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case CASE:
        printf("%x: CASE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case ESAC:
        printf("%x: ESAC\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case COLON:
	printf("%x: COLON\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case NUMBER:
        printf("%x: NUMBER\t%d, %d\n", n, n->left.inttype,
               n->right.inttype);
        break;
    case COMMA:
        printf("%x: COMMA\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case IMPLIES:
        printf("%x: IMPLIES\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case IFF:
        printf("%x: IFF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case OR:
        printf("%x: OR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case AND:
        printf("%x: AND\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case NOT:
        printf("%x: NOT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case EX:
        printf("%x: EX\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case AX:
        printf("%x: AX\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case EF:
        printf("%x: EF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case AF:
        printf("%x: AF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case EG:
        printf("%x: EG\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case AG:
        printf("%x: AG\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
/*
    case E:
        printf("%x: E\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case A:
        printf("%x: A\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
*/
    case UNTIL:
        printf("%x: UNTIL\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case EQUAL:
        printf("%x: EQUAL\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case LE:
        printf("%x: LE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case GE:
        printf("%x: GE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case LT:
        printf("%x: LT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case GT:
        printf("%x: GT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case UNION:
        printf("%x: UNION\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case SETIN:
        printf("%x: SETIN\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case MOD:
        printf("%x: MOD\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case PLUS:
        printf("%x: PLUS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case MINUS:
        printf("%x: MINUS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case TIMES:
        printf("%x: TIMES\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case DIVIDE:
        printf("%x: DIVIDE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case NEXT:
        printf("%x: NEXT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case SMALLINIT:
        printf("%x: SMALLINIT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case DOT:
        printf("%x: DOT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case TWODOTS:
	printf("%x: TWODOTS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    case ABSTRACT:
	printf("%x: ABSTRACT\t%x, %x\n", n, n->left.nodetype,
	       n->right.nodetype);
	if(nn=n->left.nodetype) debug_print_node(nn);
	if(nn=n->right.nodetype) debug_print_node(nn);
	break;
    case GROUP:
        printf("%x: GROUP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_print_node(nn);
        if(nn=n->right.nodetype) debug_print_node(nn);
        break;
    default:
	printf("%d is not implemented\n", n->type);
  }
}

void debug_fprint_node(FILE *fp, node_ptr n)
{
  node_ptr nn;

  switch(n->type) {
    case GOTO:
        fprintf(fp, "%x: GOTO\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
   case LET:
        fprintf(fp, "%x: LET\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
   case STEP:
        fprintf(fp, "%x: STEP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
   case EVAL:
        fprintf(fp, "%x: EVAL\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
   case RESET:
        fprintf(fp, "%x: RESET\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
   case ASYNC:
        fprintf(fp, "%x: ASYNC\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
   case ATOM:
	fprintf(fp, "%x: ATOM\t%s, 0\n", n, n->left.strtype->text);
	break;
    case MODULE:
	fprintf(fp, "%x: MODULE\t%x, %x\n", n, n->left.nodetype,
	       n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case MODTYPE:
	fprintf(fp, "%x: MODTYPE\t%x, %x\n", n, n->left.nodetype,
	       n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case LAMBDA:
        fprintf(fp, "%x: LAMBDA\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case CONTEXT:
        fprintf(fp, "%x: CONTEXT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case EU:
	fprintf(fp, "%x: EU\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case AU:
        fprintf(fp, "%x: AU\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case VAR:
        fprintf(fp, "%x: VAR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case DEFINE:
        fprintf(fp, "%x: DEFINE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case INIT:
        fprintf(fp, "%x: INIT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case TRANS:
        fprintf(fp, "%x: TRANS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case INVAR:
        fprintf(fp, "%x: INVAR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case SPEC:
        fprintf(fp, "%x: SPEC\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case COMPUTE:
        fprintf(fp, "%x: COMPUTE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case FAIRNESS:
        fprintf(fp, "%x: FAIRNESS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case ISA:
        fprintf(fp, "%x: ISA\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case CONSTANT:
        fprintf(fp, "%x: CONSTANT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case ASSIGN:
        fprintf(fp, "%x: ASSIGN\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case INPUT:
        fprintf(fp, "%x: INPUT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case OUTPUT:
        fprintf(fp, "%x: OUTPUT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case IMPLEMENTS:
        fprintf(fp, "%x: IMPLEMENTS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case BOOLEAN:
        fprintf(fp, "%x: BOOLEAN\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case ARRAY:
        fprintf(fp, "%x: ARRAY\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case OF:
        fprintf(fp, "%x: OF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case SCALAR:
        fprintf(fp, "%x: SCALAR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case CONS:
        fprintf(fp, "%x: CONS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case OVER:
        fprintf(fp, "%x: OVER\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case BDD:
        fprintf(fp, "%x: BDD\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case EQDEF:
        fprintf(fp, "%x: EQDEF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case FALSEEXP:
        fprintf(fp, "%x: FALSEEXP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case TRUEEXP:
        fprintf(fp, "%x: TRUEEXP\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case CASE:
        fprintf(fp, "%x: CASE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case ESAC:
        fprintf(fp, "%x: ESAC\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case COLON:
	fprintf(fp, "%x: COLON\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case NUMBER:
        fprintf(fp, "%x: NUMBER\t%d, %d\n", n, n->left.inttype,
               n->right.inttype);
        break;
    case COMMA:
        fprintf(fp, "%x: COMMA\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case IMPLIES:
        fprintf(fp, "%x: IMPLIES\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case IFF:
        fprintf(fp, "%x: IFF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case OR:
        fprintf(fp, "%x: OR\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case AND:
        fprintf(fp, "%x: AND\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case NOT:
        fprintf(fp, "%x: NOT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case EX:
        fprintf(fp, "%x: EX\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case AX:
        fprintf(fp, "%x: AX\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case EF:
        fprintf(fp, "%x: EF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case AF:
        fprintf(fp, "%x: AF\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case EG:
        fprintf(fp, "%x: EG\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case AG:
        fprintf(fp, "%x: AG\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
/*
    case E:
        fprintf(fp, "%x: E\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case A:
        fprintf(fp, "%x: A\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
*/
    case UNTIL:
        fprintf(fp, "%x: UNTIL\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case EQUAL:
        fprintf(fp, "%x: EQUAL\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case UNION:
        fprintf(fp, "%x: UNION\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case MOD:
        fprintf(fp, "%x: MOD\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case PLUS:
        fprintf(fp, "%x: PLUS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case MINUS:
        fprintf(fp, "%x: MINUS\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case TIMES:
        fprintf(fp, "%x: TIMES\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case DIVIDE:
        fprintf(fp, "%x: DIVIDE\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case NEXT:
        fprintf(fp, "%x: NEXT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case SMALLINIT:
        fprintf(fp, "%x: SMALLINIT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case DOT:
        fprintf(fp, "%x: DOT\t%x, %x\n", n, n->left.nodetype,
               n->right.nodetype);
        if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
        if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
        break;
    case ABSTRACT:
	fprintf(fp, "%x: ABSTRACT\t%x, %x\n", n, n->left.nodetype,
	       n->right.nodetype);
	if(nn=n->left.nodetype) debug_fprint_node(fp, nn);
	if(nn=n->right.nodetype) debug_fprint_node(fp, nn);
	break;
    default:
	fprintf(fp, "%d is not implemented\n", n->type);
  }
}

static void debug_print_add_rec(DdNode *f)
{
  if(Cudd_IsConstant(f)) {
    if(!(((unsigned) Cudd_V(f)) & 1)) {
      printf("%x->", f);
      debug_print_node(Cudd_V(f));
      Cudd_V(f) = Cudd_Not(Cudd_V(f));
    }
    return;
  }
  if(((unsigned)Cudd_E(f)) & 1) return;
  printf("%x: %d\t%x\t%x\n", ((unsigned) f),
         Cudd_NodeReadIndex(f), Cudd_E(f), Cudd_T(f));
  debug_print_add_rec(Cudd_E(f));
  debug_print_add_rec(Cudd_T(f));
  Cudd_E(f) = Cudd_Not(Cudd_E(f));
}

void debug_clear_mark(DdNode *f)
{
  if(Cudd_IsConstant(f)) {
    if(((unsigned) Cudd_V(f)) & 1)
      Cudd_V(f) = Cudd_Not(Cudd_V(f));
    return;
  }
  if(!(((unsigned) Cudd_E(f)) & 1)) return;
  Cudd_E(f) = Cudd_Not(Cudd_E(f));
  debug_clear_mark(Cudd_E(f));
  debug_clear_mark(Cudd_T(f));
}

void debug_print_add(DdNode *f)
{
  debug_print_add_rec(f);
  debug_clear_mark(f);
}

void debug_print_bdd(bdd_ptr f)
{
  Cudd_PrintDebug(dd_manager, f, 0, 3);
}

void debug_print_vars(node_ptr avars)
{
  for(;avars;avars=cdr(avars)) {
    node_ptr var = lookup_symbol_hash(car(avars));
    debug_print_node(car(avars));
    debug_print_add(car(var));
    printf("\n");
  }
}

bdd_ptr debug_extract_trans(bdd_ptr f, node_ptr name, node_ptr val1, node_ptr val2)
{
  node_ptr var = lookup_symbol_hash(find_atom(name));
  add_ptr var_add = (add_ptr) car(var);
  add_ptr val1_add = add_leaf(dd_manager, find_atom(val1));
  add_ptr val2_add = add_leaf(dd_manager, find_atom(val2));
  bdd_ptr r = add_to_bdd(dd_manager, add_equal(dd_manager, var_add, val1_add));
  bdd_ptr t = bdd_and(dd_manager, f, r);

  r = add_to_bdd(dd_manager, add_equal(dd_manager, add_shift_forward(dd_manager, var_add), val2_add));
  f = bdd_and(dd_manager, t, r);
  return f;
}

bdd_ptr debug_extract_trans1(bdd_ptr f, node_ptr name, node_ptr val1, node_ptr val2, node_ptr name3, node_ptr val3, node_ptr name4, node_ptr val4)

{
  node_ptr var = lookup_symbol_hash(find_atom(name));
  add_ptr var_add = (add_ptr) car(var);
  add_ptr val1_add = add_leaf(dd_manager, find_atom(val1));
  add_ptr val2_add = add_leaf(dd_manager, find_atom(val2));
  bdd_ptr r = add_to_bdd(dd_manager, add_equal(dd_manager, var_add, val1_add));
  bdd_ptr t;

  node_ptr var3_dd = lookup_symbol_hash(find_atom(name3));
  add_ptr var3_add = eval(var3_dd, Nil);
  add_ptr val3_add = add_leaf(dd_manager, find_atom(val3));
  add_ptr var4_add = (add_ptr) car(lookup_symbol_hash(find_atom(name4)));
  add_ptr val4_add = add_leaf(dd_manager, find_atom(val4));

  t = bdd_and(dd_manager, f, r);

  r = add_to_bdd(dd_manager, add_equal(dd_manager, add_shift_forward(dd_manager,var_add), val2_add));
  f = bdd_and(dd_manager, t, r);

  r = add_to_bdd(dd_manager, add_equal(dd_manager, var3_add, val3_add));
  t = bdd_and(dd_manager, f, r);
  
  r = add_to_bdd(dd_manager, add_equal(dd_manager, var4_add, val4_add));
  f = bdd_and(dd_manager, t, r);

  return f;
}

bdd_ptr debug_extract_trans2(bdd_ptr f, node_ptr name, node_ptr val1, node_ptr val2, node_ptr name3, node_ptr val3)
{
  node_ptr var = lookup_symbol_hash(find_atom(name));
  add_ptr var_add = (add_ptr) car(var);
  add_ptr val1_add = add_leaf(dd_manager, find_atom(val1));
  add_ptr val2_add = add_leaf(dd_manager, find_atom(val2));
  bdd_ptr r = add_to_bdd(dd_manager, add_equal(dd_manager, var_add, val1_add));
  bdd_ptr t = bdd_and(dd_manager, f, r);
  add_ptr var3_add = (add_ptr) car(lookup_symbol_hash(find_atom(name3)));
  add_ptr val3_add = add_leaf(dd_manager, find_atom(val3));

  r = add_to_bdd(dd_manager, add_equal(dd_manager, add_shift_forward(dd_manager,
 var_add), val2_add));
  f = bdd_and(dd_manager, t, r);

  r = add_to_bdd(dd_manager, add_equal(dd_manager, var3_add, val3_add));
  t = bdd_and(dd_manager, f, r);
  return t;
}

void debug_print_all_symbols()
{
  node_ptr as = all_symbols;

  for(;as;as=cdr(as)) {
    node_ptr asmore = lookup_symbol_hash(find_atom(car(as)));
    debug_print_node(car(as));
    if(asmore) debug_print_node(asmore);
    printf("\n");
  }
}

void printf_node_exp(node_ptr n)
{
  node_ptr nn;

  if(((unsigned)n)<1048576) return;
  switch(n->type) {
    case ATOM:
	printf("%s", n->left.strtype->text);
	break;
    case ARRAY:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf("[");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf("]");
	break;
    case CONTEXT:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(".");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case EU:
	printf("E[ ");
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" U ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf("]");
        break;
    case AU:
	printf("A[ ");
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" U ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf("]");
        break;
    case EQDEF:
        if(nn=n->left.nodetype) printf_node_exp(nn);
        printf(":=");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf("\n");
        break;
    case FALSEEXP:
        printf("0");
        break;
    case TRUEEXP:
        printf("1");
        break;
    case CASE:
        printf("CASE\n");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case COLON:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" : ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case NUMBER:
        printf("%d", n->left.inttype);
        break;
    case COMMA:
        if(nn=n->left.nodetype) printf_node_exp(nn);
        printf(", ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case IMPLIES:
	printf("(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        printf(") -> (");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case IFF:
        printf("(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(") <-> (");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case OR:
        printf("(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        printf(") | (");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        printf(")");
        break;
    case AND:
        printf("(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(") & (");
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case NOT:
        printf("! (");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case EX:
        printf("EX(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case AX:
        printf("AX(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case EF:
        printf("EF(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case AF:
        printf("AF(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case EG:
        printf("EG(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case AG:
        printf("AG(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case EQUAL:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" == ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case LE:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" <= ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case GE:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" >= ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case LT:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" < ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case GT:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" > ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case MOD:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" mod ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case PLUS:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" + ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case MINUS:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" - ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case TIMES:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" * ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case DIVIDE:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(" / ");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case NEXT:
	printf("next(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case SMALLINIT:
	printf("init(");
        if(nn=n->left.nodetype) printf_node_exp(nn);
        if(nn=n->right.nodetype) printf_node_exp(nn);
	printf(")");
        break;
    case DOT:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf(".");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case TWODOTS:
        if(nn=n->left.nodetype) printf_node_exp(nn);
	printf("..");
        if(nn=n->right.nodetype) printf_node_exp(nn);
        break;
    case CONS:
	if(nn=n->left.nodetype) printf_node_exp(nn);
	printf("\n");
	if(nn=n->right.nodetype) printf_node_exp(nn);
	break;
    default:
	printf("%d is not implemented\n", n->type);
  }
}

void fprintf_node_exp(FILE *fp, node_ptr n)
{
  node_ptr nn;

  if(n<1048576) return;
  switch(n->type) {
    case ATOM:
	fprintf(fp, "%s", n->left.strtype->text);
	break;
    case ARRAY:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "[");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "]");
	break;
    case CONTEXT:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ".");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case EU:
	fprintf(fp, "E[ ");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " U ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "]");
        break;
    case AU:
	fprintf(fp, "A[ ");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " U ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "]");
        break;
    case EQDEF:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        fprintf(fp, ":=");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "\n");
        break;
    case FALSEEXP:
        fprintf(fp, "0");
        break;
    case TRUEEXP:
        fprintf(fp, "1");
        break;
    case CASE:
        fprintf(fp, "CASE\n");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case COLON:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " : ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case NUMBER:
        fprintf(fp, "%d", n->left.inttype);
        break;
    case COMMA:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        fprintf(fp, ", ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case IMPLIES:
	fprintf(fp, "(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        fprintf(fp, ") -> (");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case IFF:
        fprintf(fp, "(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ") <-> (");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case OR:
        fprintf(fp, "(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        fprintf(fp, ") | (");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        fprintf(fp, ")");
        break;
    case AND:
        fprintf(fp, "(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ") & (");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case NOT:
        fprintf(fp, "! (");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case EX:
        fprintf(fp, "EX(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case AX:
        fprintf(fp, "AX(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case EF:
        fprintf(fp, "EF(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case AF:
        fprintf(fp, "AF(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case EG:
        fprintf(fp, "EG(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case AG:
        fprintf(fp, "AG(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case EQUAL:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " == ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case LE:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " <= ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case GE:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " >= ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case LT:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " < ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case GT:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " > ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case MOD:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " mod ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case PLUS:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " + ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case MINUS:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " - ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case TIMES:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " * ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case DIVIDE:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, " / ");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case NEXT:
	fprintf(fp, "next(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case SMALLINIT:
	fprintf(fp, "init(");
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ")");
        break;
    case DOT:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, ".");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case TWODOTS:
        if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "..");
        if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
        break;
    case CONS:
	if(nn=n->left.nodetype) fprintf_node_exp(fp, nn);
	fprintf(fp, "\n");
	if(nn=n->right.nodetype) fprintf_node_exp(fp, nn);
	break;
    default:
	fprintf(fp, "%d is not implemented\n", n->type);
  }
}

void debug_print_list_node(node_ptr n)
{
  node_ptr nn;

  if(n<1048576) return;
  switch(n->type) {
   case ATOM:
	printf("%s", n->left.strtype->text);
	break;
    case ARRAY:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf("[");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
	printf("]");
        break;
    case CONS:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
	printf("\n");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case NUMBER:
        printf("%d", n->left.inttype);
        break;
    case IMPLIES:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf("->");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case IFF:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf("<=>");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case OR:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" | ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case AND:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" & ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case NOT:
        printf("!");
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case EQUAL:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" = ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case LE:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" <= ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case GE:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" >= ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case LT:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" < ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case GT:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" > ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case UNION:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" un ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case SETIN:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" in ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case MOD:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" mod ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case PLUS:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" + ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case MINUS:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" - ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case TIMES:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" * ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case DIVIDE:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(" / ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case NEXT:
        printf("next(");
        if(nn=n->left.nodetype) debug_print_list_node(nn);
	printf(")");
        break;
    case DOT:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
        printf(".");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    case TWODOTS:
        if(nn=n->left.nodetype) debug_print_list_node(nn);
	printf(" .. ");
        if(nn=n->right.nodetype) debug_print_list_node(nn);
        break;
    default:
	printf("%d is not implemented\n", n->type);
  }
}
