/**CFile***********************************************************************

  FileName    [compileStruct.c]

  PackageName [compile]

  Synopsis    [Structure used to store compilation results.]

  Description [Structure used to store compilation results.]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "compileInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
cmp_struct_ptr cmp_struct_init()
{
  cmp_struct_ptr cmp;
  cmp = ALLOC(cmp_struct_rec, 1);
  cmp->read_model           = 0;
  cmp->flatten_hierarchy    = 0;
  cmp->build_variables      = 0;
  cmp->process_selector     = 0;
  cmp->build_frames         = 0;
  cmp->compile_check        = 0;
  cmp->build_init           = 0;
  cmp->build_model          = 0;
  cmp->fairness_constraints = 0;
  cmp->init_expr            = Nil;
  cmp->invar_expr           = Nil;
  cmp->trans_expr           = Nil;
  cmp->assign_expr          = Nil;
  cmp->procs_expr           = Nil;
  cmp->fair_expr            = Nil;
  cmp->spec_expr            = Nil;
  cmp->ltlspec_expr         = Nil;
  cmp->invar_spec_expr      = Nil;
  cmp->invar_fb_expr        = Nil;
  cmp->invar_strong_expr    = Nil;
  cmp->after_expr           = Nil;
  return(cmp);
}

int cmp_struct_get_read_model(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->read_model);
}

void cmp_struct_set_read_model(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->read_model = 1;
}

int cmp_struct_get_flatten_hrc(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->flatten_hierarchy);
}

void cmp_struct_set_flatten_hrc(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->flatten_hierarchy = 1;
}

int cmp_struct_get_build_variables(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->build_variables);
}

void cmp_struct_set_build_variables(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->build_variables = 1;
}

int cmp_struct_get_process_selector(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->process_selector);
}

void cmp_struct_set_process_selector(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->process_selector = 1;
}

int cmp_struct_get_build_frames(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->build_frames);
}

void cmp_struct_set_build_frames(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->build_frames = 1;
}

int cmp_struct_get_compile_check(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->compile_check);
}

void cmp_struct_set_compile_check(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->compile_check = 1;
}

int cmp_struct_get_build_init(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->build_init);
}

void cmp_struct_set_build_init(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->build_init = 1;
}

int cmp_struct_get_build_model(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->build_model);
}

void cmp_struct_set_build_model(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->build_model = 1;
}

int cmp_struct_get_fairness(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->fairness_constraints);
}

void cmp_struct_set_fairness(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  cmp->fairness_constraints = 1;
}

node_ptr cmp_struct_get_init(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->init_expr);
}

void cmp_struct_set_init(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->init_expr = n;
}

node_ptr cmp_struct_get_invar(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->invar_expr);
}

void cmp_struct_set_invar(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->invar_expr = n;
}

node_ptr cmp_struct_get_trans(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->trans_expr);
}
void cmp_struct_set_trans(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->trans_expr = n;
}

node_ptr cmp_struct_get_assign(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->assign_expr);
}
void cmp_struct_set_assign(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->assign_expr = n;
}

node_ptr cmp_struct_get_procs(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->procs_expr);
}
void cmp_struct_set_procs(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->procs_expr = n;
}

node_ptr cmp_struct_get_fair(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->fair_expr);
}
void cmp_struct_set_fair(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->fair_expr = n;
}

node_ptr cmp_struct_get_spec(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->spec_expr);
}
void cmp_struct_set_spec(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->spec_expr = n;
}

node_ptr cmp_struct_get_ltlspec(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->ltlspec_expr);
}
void cmp_struct_set_ltlspec(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->ltlspec_expr = n;
}

node_ptr cmp_struct_get_invar_spec(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->invar_spec_expr);
}
void cmp_struct_set_invar_spec(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->invar_spec_expr = n;
}

node_ptr cmp_struct_get_invar_fb(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->invar_fb_expr);
}
void cmp_struct_set_invar_fb(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->invar_fb_expr = n;
}

node_ptr cmp_struct_get_invar_strong(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->invar_strong_expr);
}
void cmp_struct_set_invar_strong(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->invar_strong_expr = n;
}

node_ptr cmp_struct_get_after(cmp_struct_ptr cmp)
{
  assert(cmp != NULL);
  return(cmp->after_expr);
}
void cmp_struct_set_after(cmp_struct_ptr cmp, node_ptr n)
{
  assert(cmp != NULL);
  cmp->after_expr = n;
}
