/**CHeaderFile*****************************************************************

  FileName    [compileInt.h]

  PackageName [compile]

  Synopsis    [Internal declaration needed for the compilation.]

  Description [This file provides the user routines to perform
  compilation of the read model into BDD.]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _compile_int
#define _compile_int

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "mc.h"
#include "img.h"
#include "cmd.h"
#include "opt.h"

/* Yuan Lu */
#include "abs.h"



/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
EXTERN options_ptr options;

EXTERN FILE * nusmv_stderr;
EXTERN FILE * nusmv_stdout;

EXTERN int yylineno;

EXTERN DdManager * dd_manager;

EXTERN cmp_struct_ptr cmps;
EXTERN node_ptr parse_tree;
EXTERN node_ptr state_variables;
EXTERN node_ptr real_state_variables;
EXTERN node_ptr all_symbols;
EXTERN node_ptr input_variables;
EXTERN node_ptr all_variables;
EXTERN node_ptr zero_number;
EXTERN node_ptr one_number;
EXTERN node_ptr boolean_type; 

EXTERN node_ptr fairness_constraints_bdd;
EXTERN bdd_ptr fair_states_bdd;

EXTERN add_ptr trans_add;
EXTERN bdd_ptr trans_bdd;

EXTERN node_ptr variable_names[];

EXTERN node_ptr cp_trans_add;
EXTERN node_ptr cp_trans_bdd;
EXTERN node_ptr dp_trans_add;
EXTERN node_ptr dp_trans_bdd;
EXTERN node_ptr forward_quantifiers_add;
EXTERN node_ptr forward_quantifiers_bdd;
EXTERN node_ptr reverse_quantifiers_add;
EXTERN node_ptr reverse_quantifiers_bdd;
EXTERN node_ptr Iwls95_Fwd_trans;
EXTERN node_ptr Iwls95_Bwd_trans;

EXTERN add_ptr invar_add;
EXTERN bdd_ptr invar_bdd;
/* Yuan Lu */
EXTERN add_ptr invar_add_orig;
EXTERN add_ptr invar_bdd_orig;

EXTERN add_ptr frame_add;

EXTERN add_ptr init_add;
EXTERN bdd_ptr init_bdd;

EXTERN add_ptr state_variables_add;
EXTERN bdd_ptr state_variables_bdd;

EXTERN add_ptr next_state_variables_add;
EXTERN bdd_ptr next_state_variables_bdd;

EXTERN add_ptr input_variables_add;
EXTERN bdd_ptr input_variables_bdd;

EXTERN add_ptr next_input_variables_add;
EXTERN add_ptr next_input_variables_bdd;

EXTERN add_ptr input_vars_add;

EXTERN node_ptr running_atom;

EXTERN bdd_ptr running_add;

EXTERN node_ptr proc_selector_internal_vname;
EXTERN add_ptr process_selector_add;

EXTERN bdd_ptr reachable_states_bdd;
EXTERN int is_input_decl;

/* Yuan Lu : max_part_list */
EXTERN node_ptr max_part_list;
EXTERN node_ptr abs_expr;
EXTERN node_ptr abs_expr_pre;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN void build_model_monolithic ARGS((node_ptr, node_ptr, node_ptr, add_ptr));
EXTERN void print_monolithic_info ARGS((void));

EXTERN void Compile_CompileModelConj ARGS((node_ptr, node_ptr, node_ptr, add_ptr));
EXTERN void print_conj_part_info ARGS((void));
EXTERN void print_conj_part_detailed_info ARGS((void)); 

EXTERN void Compile_CompileModelIwls95 ARGS((node_ptr, node_ptr, node_ptr, add_ptr));
EXTERN void print_iwls95cp_part_info ARGS((void));
EXTERN void print_iwls95cp_detailed_info ARGS((void));

EXTERN void Compile_CompileModelDisj ARGS((node_ptr, node_ptr, node_ptr, add_ptr));
EXTERN void print_disj_part_info ARGS((void));

EXTERN add_ptr  Compile_EncodeVar ARGS((node_ptr, node_ptr, int));
EXTERN node_ptr Compile_GetOrdering ARGS((void));

EXTERN void     init_check_constant_hash    ARGS((void));
EXTERN void     insert_check_constant_hash  ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_check_constant_hash  ARGS((node_ptr));
EXTERN void     clear_check_constant_hash   ARGS((void));

EXTERN void     init_value_hash       ARGS((void));
EXTERN void     insert_value_hash     ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_value_hash     ARGS((node_ptr));
EXTERN void     clear_value_hash      ARGS((void));

EXTERN void     init_module_hash      ARGS((void));
EXTERN void     insert_module_hash    ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_module_hash    ARGS((node_ptr));
EXTERN void     clear_module_hash     ARGS((void));

EXTERN void     init_constant_hash    ARGS((void));
EXTERN void     insert_constant_hash  ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_constant_hash  ARGS((node_ptr));
EXTERN void     clear_constant_hash   ARGS((void));

EXTERN void     init_frame_hash       ARGS((void));
EXTERN void     insert_frame_hash     ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_frame_hash     ARGS((node_ptr));
EXTERN void     clear_frame_hash      ARGS((void));

EXTERN void Iwls95OrderClusters ARGS((DdManager * dd, node_ptr Unordered, node_ptr *Ordered, bdd_ptr PS, bdd_ptr PI, bdd_ptr NS, Iwls95OptionStruct_t *Options));
EXTERN node_ptr Iwls95ComputeClusterInfo ARGS((DdManager *dd, node_ptr Q, bdd_ptr PS, bdd_ptr PI, bdd_ptr NS));
EXTERN bdd_ptr Iwls95ComputeCLustersCube ARGS((DdManager * dd, node_ptr set_of_clusters));
EXTERN bdd_ptr Iwls95CubeAnd ARGS((DdManager *dd, bdd_ptr A, bdd_ptr B));
EXTERN void Iwls95MakeClusters ARGS((DdManager * dd, node_ptr RelationList, node_ptr * NewRelationList, Iwls95OptionStruct_t * Options));

EXTERN int Iwls95PrintOption ARGS((FILE * fp));
EXTERN int CommandIwls95PrintOption ARGS((int argc, char ** argv));
EXTERN int CommandIwls95PrintClusterInfo ARGS((int argc, char ** argv));
EXTERN void Iwls95MakePartition ARGS((DdManager *, node_ptr, node_ptr *, node_ptr *, Iwls95OptionStruct_t *, bdd_ptr, bdd_ptr, bdd_ptr));
EXTERN Iwls95Cluster_Info_t * Iwls95ClusterInfoAlloc ARGS((void));

#endif /* _compile_int */
