/**CHeaderFile*****************************************************************

  FileName    [cmdInt.h]

  PackageName [cmd]

  Synopsis    [Internal declarations for command package.]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  Copyright (c) 1998 by ITC-IRST and Carnegie Mellon University.
  All Rights Reserved.  This software is for educational purposes only.
  Permission is given to use, copy, modify, and distribute this software
  and its documentation provided that this introductory message is not
  removed and no monies are exchanged. No guarantee is expressed or
  implied by the distribution of this code. 
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: cmdInt.h,v 1.4 1997/02/19 17:32:52 abel Exp $]

******************************************************************************/

#ifndef _CMDINT
#define _CMDINT

#include "sm.h"
#include "cmd.h"
#include "opt.h"
#include "avl.h"
#include "dd.h"


#if STDC_HEADERS
#  include <string.h>
#  include <stdlib.h>
#else
void free();
char *strncpy();
#endif

/*
 * This is for Solaris -- it needs to be convinced that we're actually
 * using BSD-style calls in sys/ioctl.h, otherwise it doesn't find
 * "ECHO" "CRMOD" and "TIOCSTI" when compiling cmdFile.c
 */
#define BSD_COMP

#if IOCTL_WITH_TERMIOS
#  include <sys/ioctl.h>
#  include <sys/termios.h>
#else
#  if HAVE_SYS_IOCTL_H
#    include <sys/ioctl.h>
#  else
#    if HAVE_SYS_TERMIOS_H
#      include <sys/termios.h>
#    endif
#  endif
#endif

/* Linux and its wacky header files... */
/*
#if HAVE_BSD_SGTTY_H
#  include <bsd/sgtty.h>
#endif
*/

#if HAVE_SYS_SIGNAL_h
#  include <sys/signal.h>
#endif
#if HAVE_SIGNAL_H
#  include <signal.h>
#endif

/*
 * No unix system seems to be able to agree on how to access directories,
 * which cmdFile.c needs to do.  This solution, suggested by the autoconf
 * distribution, seems to handle most of the nonsense.
 */

#if HAVE_DIRENT_H
#  include <dirent.h>
#  define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#  define dirent direct
#  define NAMLEN(dirent) (dirent)->d_namlen
#  if HAVE_SYS_NDIR_H
#    include <sys/ndir.h>
#  endif
#  if HAVE_SYS_DIR_H
#    include <sys/dir.h>
#  endif
#  if HAVE_NDIR_H
#    include <ndir.h>
#  endif
#endif

/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/
typedef struct CmdAliasDescrStruct {
  char *name;
  int argc;
  char **argv;
} CmdAliasDescr_t;

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
extern avl_tree *cmdCommandTable;
extern avl_tree *cmdFlagTable;
extern avl_tree *cmdAliasTable;
extern array_t  *cmdCommandHistoryArray;
extern options_ptr options;

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void CmdCommandFree(char * value);
EXTERN char * CmdFgetsFilec(char * buf, int size, FILE * stream, char * prompt);
EXTERN char * CmdFgetsFilec(char * buf, int size, FILE * stream, char * prompt);
EXTERN char * CmdHistorySubstitution(char * line, int * changed);
EXTERN void CmdFreeArgv(int argc, char ** argv);
EXTERN void CmdAliasFree(char * value);

/**AutomaticEnd***************************************************************/

#endif /* _CMDINT */
