/**CHeaderFile*****************************************************************

  FileName    [cmd.h]

  PackageName [cmd]

  Synopsis    [Implements command line interface, and miscellaneous commands.]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  Copyright (c) 1998 by ITC-IRST and Carnegie Mellon University.
  All Rights Reserved.  This software is for educational purposes only.
  Permission is given to use, copy, modify, and distribute this software
  and its documentation provided that this introductory message is not
  removed and no monies are exchanged. No guarantee is expressed or
  implied by the distribution of this code. 
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: cmd.h,v 1.5 1997/03/04 08:37:39 ravi Exp $]

******************************************************************************/

#ifndef _CMD
#define _CMD

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include <setjmp.h>
#include <signal.h>

/* #include "util.h" */

/* 
  The two macros below are used by the GUI to understand the execution
  status of a command. They are printed out by CommandSource
*/
#define GUI_TOKEN_COMMAND_ERROR "^^^^^commander^^^^^"
#define GUI_TOKEN_COMMAND_OK    "^^^^^commandOK^^^^^"

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef int (*PFI)();

 
/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

#if HAVE_LIBREADLINE
EXTERN char *readline(char *PROMPT);
EXTERN void add_history(char *line);
#endif
#if HAVE_SETVBUF
EXTERN int setvbuf(FILE*, char*, int mode, size_t size);
#endif
#ifdef PURIFY
EXTERN void purify_all_inuse();
#endif
EXTERN void Cmd_CommandAdd(char * name, PFI funcFp, int changes);
EXTERN int Cmd_CommandExecute(char * command);
EXTERN FILE * Cmd_FileOpen(char * fileName, char * mode, char ** realFileName_p, int silent);
EXTERN char * Cmd_FlagReadByName(char * flag);
EXTERN void Cmd_Init();
EXTERN void Cmd_End();

/**AutomaticEnd***************************************************************/

#endif /* _CMD */















