/**CHeaderFile*****************************************************************

  FileName    [absInt.h]

  PackageName [abs]

  Synopsis    [Internal declaration needed for the abstraction.]

  Description [This file provides the user routines to perform
  abstraction on the model.]

  Author      [Yuan Lu]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _abs_int
#define _abs_int

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "mc.h"
#include "img.h"
#include "cmd.h"
#include "opt.h"
#include "error.h"
#include "abs.h"
#include "debug.h"
#include <math.h>

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
EXTERN options_ptr options;
EXTERN node_ptr all_variables;
EXTERN DdManager *dd_manager;
EXTERN options_ptr options;
EXTERN bdd_ptr init_bdd;
EXTERN bdd_ptr init_bdd_orig;
EXTERN bdd_ptr init_bdd_orig1;
EXTERN bdd_ptr invar_bdd;
EXTERN bdd_ptr invar_bdd_orig;
EXTERN bdd_ptr trans_bdd;
EXTERN bdd_ptr trans_add;
EXTERN bdd_ptr trans_bdd_orig;
EXTERN bdd_ptr trans_add_orig;
EXTERN node_ptr cp_trans_add;
EXTERN node_ptr cp_trans_bdd;
EXTERN node_ptr cp_trans_add_orig;
EXTERN node_ptr cp_trans_bdd_orig;
EXTERN node_ptr dp_trans_add;
EXTERN node_ptr dp_trans_bdd;
EXTERN node_ptr Iwls95_Fwd_trans;
EXTERN node_ptr Iwls95_Bwd_trans;
EXTERN node_ptr abs_expr;
EXTERN node_ptr abs_expr_pre;
EXTERN node_ptr abs_rel_prod;
EXTERN node_ptr forward_quantifiers_bdd;
EXTERN node_ptr forward_quantifiers_add;
EXTERN node_ptr forward_quantifiers_bdd_orig;
EXTERN node_ptr forward_quantifiers_add_orig;
EXTERN node_ptr reverse_quantifiers_bdd;
EXTERN node_ptr reverse_quantifiers_add;
EXTERN node_ptr reverse_quantifiers_bdd_orig;
EXTERN node_ptr reverse_quantifiers_add_orig;
EXTERN add_ptr state_variables_add;
EXTERN add_ptr next_state_variables_add;
EXTERN add_ptr input_variables_add;
EXTERN add_ptr next_input_variables_add;
EXTERN node_ptr max_part_list;

EXTERN bdd_ptr fair_states_bdd;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN void init_abstract_hash ARGS(());
EXTERN void insert_abstract_hash ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_abstract_hash ARGS((node_ptr));
EXTERN void clear_abstract_hash ARGS(());

EXTERN void init_depend_hash ARGS(());
EXTERN void insert_depend_hash ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_depend_hash ARGS((node_ptr));
EXTERN void clear_depend_hash ARGS(());


#endif /* _abs_int */
