/**CFile***********************************************************************

  FileName    [absCmd.c]

  PackageName [abs]

  Synopsis    [Shell interface for the abs package.]

  Description [This file contains the interface of the abs package
  with the interactive shell.]

  SeeAlso     [cmdCmd.c]

  Author      [Yuan Lu]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "absInt.h"

static char rcsid[] UTIL_UNUSED = "$Id:$";

/* prototypes of the command functions */

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/**Variable********************************************************************

  Synopsis    []

  Description []

  SeeAlso     []

******************************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Initializes the abs package.]

  Description        [Initializes the abs package.]

  SideEffects        []

******************************************************************************/
void Abs_Init(void)
{
  Cmd_CommandAdd("auto_gen_abs", CommandAutoGenAbs, 0);
  Cmd_CommandAdd("build_abs_model", CommandBuildAbsModel, 0);
}

/**Function********************************************************************

  Synopsis           [Shut down the abs package]

  Description        [Shut down the abs package]

  SideEffects        []

  SeeAlso            []

******************************************************************************/
void Abs_End(void)
{
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Performs the automatic abstraction function
  generation and then returns ????????.]

  CommandName        [auto_gen_abs] 	   

  CommandSynopsis    [Performs the automatic abstraction function
  generation and then returns ?????????.]

  CommandArguments   [\[-h\] \[-abs\]]  

  CommandDescription [ By looking through the model, suggest abstraction
  functions for the variables to users.

  Command options:<p>
  <dl>
    <dt> <tt>-abs</tt>
       <dd> Sets the environment variable <tt> <\tt>.
  </dl>
  ]  

  SideEffects        []

******************************************************************************/
int CommandAutoGenAbs(int argc, char **argv)
{
}

/**Function********************************************************************

  Synopsis           [Build the abstract model according to given
  abstraction functions.]

  CommandName        [build_abs_model] 	   

  CommandSynopsis    [Build the abstract model according to given
  abstraction functions.]  

  CommandArguments   [\[-h\]]  

  CommandDescription [
  ]

  SideEffects        []

******************************************************************************/
int CommandBuildAbsModel()
{
}

