# FileName	[dependency.make]
#
# PackageName	[NuSMV]
#
# Synopsis	[Makefile to automatically create the dependency files.]
#
# Description	[This file is called from the main Makefile.]
#
# SeeAlso	[Makefile.in]
#
# Author	[Marco Roveri]
#
# Copyright	[Copyright (c) 1998 by ITC-IRST and Carnegie Mellon University.
#         All Rights Reserved.  This software is for educational purposes only.
#         Permission is given to use, copy, modify, and distribute this software
#         and its documentation provided that this introductory message is not
#         removed and no monies are exchanged. No guarantee is expressed or
#         implied by the distribution of this code. 
#         Send bug-reports and/or questions to: nusmv@irst.itc.it]
#
# Revision	[$Id:$]

include $(PKGNAME).make
VPATH = $(vpath)

ifdef DEPENDENCYFILES
$(PKGNAME).d : $(DEPENDENCYFILES) $(HEADERS) $(PKGNAME).make
	@echo -n "Dependency file $(PKGNAME).d->"
	@$(CC) -MM $(CFLAGS) $(AC_FLAGS) $(INCLUDEDIRS) \
	$(filter %.c, $^) | \
	sed 's/^[a-zA-Z0-9_]*\.o[ :]*/$(objectdir)\/&/g' > $@
	@echo "Created."
else
$(PKGNAME).d :
	@echo "No dependency files given in $(PKGNAME).make"
	@echo "Define the variable DEPENDENCYFILES to create the dependencies"
endif
