open Ir

let start = Temp.newLabel ()
let a = Temp.newLabel ()
let b = Temp.newLabel ()
let b' = Temp.newLabel ()
let c = Temp.newLabel ()
let d = Temp.newLabel ()
let d' = Temp.newLabel ()
let e = Temp.newLabel ()
let f = Temp.newLabel ()
let finish = Temp.getReturnLabel ()

let split l1 l2 =
    CJUMP (EQ, CONST (0l, Pcc.Bogus), CONST (0l, Pcc.Bogus), l1, l2)

(* from Ball and Larus *)
let bblocks =
    [ [LABEL a; split b c];
      [LABEL b; split c d];
      [LABEL c; JUMP d];
      [LABEL d; split e finish];
      [LABEL e; JUMP finish] ]

(*
(* smaller *)
let bblocks =
    [ [LABEL start; JUMP a];
      [LABEL a; split b c];
      [LABEL b; split d a];
      [LABEL c; JUMP finish];
      [LABEL d; split e f];
      [LABEL e; split b finish];
      [LABEL f; JUMP finish] ]
    (* NB: finish = Temp.getReturnLabel (), block will be added by CFG.make *)
*)

(*
let bblocks =
    [ [LABEL start; JUMP a];
      [LABEL a; split b c];
      [LABEL b; split b' a];
      [LABEL b'; split c d];
      [LABEL c; JUMP d];
      [LABEL d; split a d'];
      [LABEL d'; split e f];
      [LABEL e; split b finish];
      [LABEL f; JUMP finish] ]
    (* NB: finish = Temp.getReturnLabel (), block will be added by CFG.make *)
*)

let cfg = CFG.make bblocks
let dag = Path.makedag cfg

let () = CFG.print "cfg.dot" cfg
let () = Path.print "dag.dot" cfg dag

let lst = Path.rev_toposort dag (CFG.entry cfg)
let () =
    print_string "toposort: ";
    List.iter (fun node -> print_string (CFG.string_of_node node)) lst;
    print_newline ()

let vals = Path.edge_values dag lst
let () =
    print_string "edge_values:\n";
    CFG.NodePairMap.iter
        (fun (s, t) v ->
            print_string "  (";
            print_string (CFG.string_of_node s);
            print_string ", ";
            print_string (CFG.string_of_node t);
            print_string ") = ";
            print_string (string_of_int v);
            print_newline ())
        vals
