(* summary.ml *)
(* 15-411 *)
(* by Roland Flury *)
(* @version $Id: summary.ml,v 1.2 2003/09/02 14:52:45 rflury Exp $ *)

module HA = Hashtbl

let showSummaryFlag = ref false

let fun_names = ref [] 
let num_funs = ref 0

(* add a function to the list of all processed function-names *)
let add_fun_name fName = 
  if(not (List.mem fName !fun_names)) then (
    fun_names := fName :: !fun_names;
    num_funs := 1 + !num_funs;
   )
(************************************************************************)
(* SSA-ABCE *)
(************************************************************************)

let num_rm_bran : (string, int) HA.t = HA.create 57 
let rm_branche fun_Name = 
  if(!showSummaryFlag) then
    if(HA.mem num_rm_bran fun_Name) then
      HA.replace num_rm_bran fun_Name (1 + HA.find num_rm_bran fun_Name)
    else (
      add_fun_name fun_Name;
      HA.add num_rm_bran fun_Name 1;
     )


(************************************************************************)
(* Register Allocation *)
(************************************************************************)

(* Add a # of spills in a function with given name *)
let num_of_spills : (string, int) HA.t = HA.create 57 
let add_spills fun_Name number = 
  if(!showSummaryFlag) then
    if(HA.mem num_of_spills fun_Name) then
      HA.replace num_of_spills fun_Name (number + HA.find num_of_spills fun_Name)
    else (
      add_fun_name fun_Name;
      HA.add num_of_spills fun_Name number
     )

(* Store the used registers *)
let used_regs : (string, string) HA.t = HA.create 57 
let add_used_regs fName regs =
  HA.replace used_regs fName regs

(************************************************************************)
(* Printing *)
(************************************************************************)
      
let print_summary () = 
  if(!showSummaryFlag) then (
    let sum = ref "" in
    let shift = ref "" in
    let add s = sum := !sum ^ !shift ^ s in
    add "**********************************************************************\n";
    add "                           SUMMARY\n";
    add "**********************************************************************\n";
    shift := " ";
    let total_spills = ref 0 in
    let total_cond_br = ref 0 in
    List.iter (fun fName -> 
      add "\n";
      add (Printf.sprintf "%s:\n" fName); 
      shift := "   ";

      (* The number of spills *)
      let tmp = 
	if(HA.mem num_of_spills fName) then
	  HA.find num_of_spills fName
	else
	  0;
      in
      total_spills := !total_spills + tmp;
      add (Printf.sprintf "Number of spills: %i\n" tmp);

      (* The used registers *)
      if(HA.mem used_regs fName) then
	add (Printf.sprintf "Used registers: %s\n" (HA.find used_regs fName));

      (* Number of removed Conditional branches *)
      if(HA.mem num_rm_bran fName) then (
	let tmp = HA.find num_rm_bran fName in
	add (Printf.sprintf "Removed cond. branches: %i\n" tmp);
	total_cond_br := !total_cond_br + tmp;
      ) else
	add "Removed cond. branches: None\n";
      
      
      shift := " ";
	      ) !fun_names;

    shift := "";
    add "**********************************************************************\n";
    add (Printf.sprintf " Number of functions: %i\n" !num_funs);
    add (Printf.sprintf " Average number of spills: %.1f\n" 
	   ((float_of_int !total_spills) /. (float_of_int !num_funs)));
    add (Printf.sprintf " Total number of removed cond. branches: %i\n"
	   !total_cond_br);
    add "**********************************************************************\n";
    add "                         END SUMMARY\n";
    add "**********************************************************************\n";
    print_string !sum;
   )

  
