(* pcc.ml *)
(* 15-411 *)
(* by Roland Flury *)
(* @version $Id: pcc.ml,v 1.2 2003/08/11 13:04:44 rflury Exp $ *)

(* Representation of our types for PCC *)
type pccType =
  | Bogus
  | Int
  | Pointer of pccType
  | Struct of string       (* struct given by name *)
  | Record of pccType list (* immediate struct (used for pointers) *)
(* | NS *)



let rec pccType2string = function
  | Bogus -> "!!BOGUS!!"
  | Int -> "int"
  | Pointer(t) -> pccType2string t ^ "*"
  | Struct(s) -> s
  | Record([]) -> "[]"
  | Record(head :: tail) -> "[ " ^ pccType2string head ^
      (List.fold_left (fun res t -> 
	res ^ " | " ^ pccType2string t) "" tail) ^ " ]"
