(* munch.mli *)
(* 15-411 *)
(* by Roland Flury *)
(* @version $Id: munch.mli,v 1.2 2003/08/11 13:04:43 rflury Exp $ *)

(* Munches traced IR to assem-code. 
 * Returns a tuple-list (fName, lili) where lili is a list
 * of BB, consisting themselves of the assembly-code and a
 * list of labels to which the control-flow might branch *)
val munch_program : (string * Ir.stmt list list) list -> 
  (string * (Assem.instr list * Temp.label list) list) list

val munch_fun : (string * Ir.stmt list list) -> 
  (string * (Assem.instr list * Temp.label list) list)

val print : (Temp.temp -> string -> string) -> 
  (string * (Assem.instr list * Temp.label list) list) list -> unit

val print_fun : (Temp.temp -> string -> string) -> 
  (string * (Assem.instr list * Temp.label list) list) -> unit

(* If true, %ecx and %edx are stored on the stack before calling a function
 * and restored on return *)
val storeCallerSave : bool ref

val eax : int
val ecx : int
val edx : int
val ebx : int
val esi : int
val edi : int
val esp : int
val ebp : int
