(* Create the command-line given the file-name (infile) and a list of 
 * options (cppFlagList) that are passed to cpp *)
let commandLine infile cppFlagList = 
  "/usr/libexec/gcc/darwin/ppc/3.1/tradcpp0 " ^
  "-C -E " ^
  (List.fold_left (fun r s -> r ^ s ^ " ") 
     "" !cppFlagList) ^ 
  !infile ^ " " ^ 
  !infile ^ ".cpp "


(* Create the command-line for calling gcc *)
let gcc_commandLine outfile outfile_exe gccFlagList = 
  "gcc " ^ !outfile ^ 
  " -o " ^ !outfile_exe ^ 
  (List.fold_left (fun r s -> r ^ " " ^ s) 
     "" !gccFlagList)

