type forloop = {
  for_condition: Temp.label;
  for_entry: Temp.label;
  for_exit: Temp.label;
  for_continue: Temp.label
}

type whileloop = {
  while_entry: Temp.label;
  while_exit: Temp.label;
  while_test: Temp.label
}

type loop =
  | For of forloop
  | While of whileloop
  
let h : (string, loop list) Hashtbl.t = Hashtbl.create 0

let get_loops fname = try Hashtbl.find h fname with Not_found -> []

let add_loop fname loop = Hashtbl.replace h fname (loop :: (get_loops fname))

