#ifndef __L3RT_H__
#define __L3RT_H__

//#define USE_MALLOC

#ifndef USE_MALLOC
#include "gc.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* These are the entry points for code emitted by the L3
 * compiler */
extern void _l3main (int argc, char **argv);

/* These are the basic runtime functions */

void * _alloc (unsigned int nbytes);
void _pointer_error(const char* srcfile, int** fptr, int line, int error);
void _l3_error (const char *srcfile, unsigned int line,
		const char *errmsg);

//Basic console support
void print_int(int i);
void print_bool(int b);
void print_space(int n);
void print_char(int c);
void print_newline();
void print_tab();
void print_flush();
int read_int();

#endif
