#include "l3rt.h"

#define OFFSET	0
#define SIZE	1

#define NULLERROR   0
#define SIZEERROR   1
#define ZEROERROR   2

//#define FLUSH

void print_flush() {
  fflush(stdout);
}

void print_int(int i) {
  fprintf(stdout, "%d", i);
#ifdef FLUSH
  print_flush();
#endif
}

void print_char(int c) {
  fprintf(stdout, "%c", c);
#ifdef FLUSH
  print_flush();
#endif
}

void print_bool(int b) {
  if (b != 0)
    fprintf(stdout, "true");
  else
    fprintf(stdout, "false");
#ifdef FLUSH
  print_flush();
#endif
}

void print_newline() {
  fprintf(stdout, "\n");
#ifdef FLUSH
  print_flush();
#endif
}

void print_tab() {
  fprintf(stdout, "\t");
#ifdef FLUSH
  print_flush();
#endif
}

void print_space(int n) {
  int i;
  for (i = 0; i < n; i++)
    fprintf(stdout, " ");
#ifdef FLUSH
  print_flush();
#endif
}

int read_int() {
  int i;
  i = 0;
  if(!scanf("%i",&i)) {
    scanf("%*s"); // read illegal chars & discard.
  }
  return i;
}

void* _alloc (unsigned int nbytes) {
  
  void *ret;
  
#ifdef USE_MALLOC
  if ((ret = malloc (nbytes)) == NULL) 
#else
    if ((ret = GC_MALLOC (nbytes)) == NULL)  
#endif
    {
      fprintf (stderr, "out of memory!\n");
      exit (2);
    }    
    
    return ret;
}

void _l3_error (const char *srcfile, unsigned int line,
		const char *errmsg)
{
  if (srcfile == NULL){
    if (errmsg == NULL)
      fprintf (stderr, "RUNTIME: No message\n");
    else
      fprintf (stderr, "RUNTIME: %s\n", errmsg);
  } else {
    if (errmsg == NULL)
      fprintf (stderr, "RUNTIME: %s:%d No Message\n", srcfile, line);
    else fprintf (stderr, "RUNTIME: %s:%d: %s\n", srcfile, line, errmsg);
  }

  exit(-1);
}

void _pointer_error(const char* srcfile, int** fptr, int line, int error) {

  char fbuffer[512];

  if (srcfile == NULL)
    strcpy(fbuffer, "_");
  else
    strcpy(fbuffer, srcfile);

  switch (error) {
  case NULLERROR:
    fprintf(stderr, "RUNTIME: %s:%d PTRERROR: Attempted to dereference null pointer!\n", 
	    fbuffer, line);
    break;
  case SIZEERROR:
    fprintf(stderr, "RUNTIME: %s:%d PTRERROR: Index >= Size (Index: %d Size: %d)\n",
	    fbuffer, line, (int)fptr[1], (int)fptr[2]);
    break;
  case ZEROERROR:
    fprintf(stderr, "RUNTIME: %s:%d PTRERRORL Index < 0\n", fbuffer, line);
    break;
  }

  exit(-1);
}






