//Mike Maxim
//Simple graphics functions using OpenGL/GLUT


#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <GL/gl.h>
#include <GL/glut.h>

void* glut_thread(void*);
void renderScene();

static int g_x,g_y,g_cx,g_cy;
static char* g_screen=NULL;
static pthread_mutex_t g_slock;
static int g_inited=0;

static int mouse_up_x, mouse_down_x, mouse_up_y, mouse_down_y, mouse_button;

void create_window(int x, int y, int cx, int cy) {
  pthread_t thread;
  int i;
  int* params;
  char** argv;

  if (g_screen != NULL) return;

  g_screen = (char*) malloc(cx*cy*3);
  for (i = 0; i < cx*cy*3; i++) { g_screen[i] = 0; }
  
  params = (int*) malloc(2 * sizeof(int));
  argv = (char**) malloc(1);
  argv[0] = (char*) malloc(256);
  strcpy(argv[0], "leetness");
  params[0] = 1; params[1] = (int)argv;
  g_x = x; g_y = y; g_cx = cx; g_cy = cy;

  pthread_mutex_init(&g_slock, NULL);
  pthread_create(&thread, NULL, glut_thread, (void*)params);

}


void set_pixel(int x, int y, int r, int g, int b) {
  if (x >= g_cx || y >= g_cy || x < 0 || y < 0) return;

  pthread_mutex_lock(&g_slock);
  g_screen[(y*g_cx*3) + (x*3)] = (char)r;
  g_screen[(y*g_cx*3) + (x*3) + 1] = (char)g;
  g_screen[(y*g_cx*3) + (x*3) + 2] = (char)b;
  pthread_mutex_unlock(&g_slock);
}

void refresh() {
  if (!g_inited) return;
  pthread_mutex_lock(&g_slock);
  glutPostRedisplay();
  pthread_mutex_unlock(&g_slock);
}

void renderScene(void) {
  pthread_mutex_lock(&g_slock);
  glClear(GL_COLOR_BUFFER_BIT);
  glDrawPixels(g_cx, g_cy, GL_RGB, GL_UNSIGNED_BYTE, g_screen);
  glFlush();
  pthread_mutex_unlock(&g_slock);
  g_inited = 1;
}


void mousefn(int button, int updown, int x, int y) {
  //  printf("mouse ");
  if(updown == 0) {
    //    printf("down ");
    mouse_down_x = x;
    mouse_down_y = y;
  } else {
    //    printf("up ");
    mouse_up_x = x;
    mouse_up_y = y;
  }
  mouse_button = button;
  //  printf("x:%i y:%i button %i\n", x, y, button);
}



/* updown: 0=down, 1=up;
 * xy : 0=x; 1=y */
int getMouse(int updown, int xy) {
  if(updown == 0) { // down
    if(xy == 0) { // x
      return mouse_down_x;
    } else {
      return mouse_down_y;
    }
  } else { // up
    if(xy == 0) { // x
      return mouse_up_x;
    } else {
      return mouse_up_y;
    }
  }
}

int getMouseButton() {
  return mouse_button;
}

void update(int val) {
  refresh();
  if(val != 0)
    glutTimerFunc(1000, update, val);
}

void* glut_thread(void* params) {

  int* iparams = (int*) params;

  glutInit(&iparams[0], (char**) iparams[1]);
  glutInitDisplayMode(GLUT_DEPTH | GLUT_SINGLE | GLUT_RGBA);
  glutInitWindowPosition(g_x,g_y);
  glutInitWindowSize(g_cx,g_cy);
  glutCreateWindow("L3 Graphics Scene");
  glutDisplayFunc(renderScene);

  glutMouseFunc (mousefn);


  update(1);

  glutMainLoop();

  return NULL;
}

