(************************************************************************)
(* List helpers *)
(************************************************************************)

(* Union two lists, not introducing duplicates *)
let list_union a b = 
  List.fold_left (fun res x -> 
    if(List.mem x b) then
      res
    else
      x :: res
		 ) b a

(* Returns a list containing all elements of a but not those in b *)
let list_minus a b = 
  let res = List.fold_left (fun res x -> 
    if(List.mem x b) then
      res
    else
      x :: res
			   ) [] a in
  List.rev res

(* Replaces an every occurence of old_e in list with new_e *)
let list_replace_entry list old_e new_e = 
  List.map (fun e -> 
    if(e = old_e) then
      new_e
    else
      e
	   ) list

(* removes all duplicates in a list *)
let list_no_dup list =
  List.fold_left (fun res e -> 
    if(List.mem e res) then
      res
    else
      e :: res
		 ) [] list

(************************************************************************)
(* Managing differnt calling conventions Linux - Windows *)
(************************************************************************)

(* Set to true if compiling for windows *)
let isWindows = ref false

(* Adds an underscore to each external symbol if compiling for windows *)
let get_external_symbol name = 
  if(!isWindows) then
    "_" ^ name
  else
    name
