type token =
  | ID of (string)
  | INT of (int32)
  | LBRACE
  | RBRACE
  | LPAREN
  | RPAREN
  | LBRACKET
  | RBRACKET
  | PLUS
  | MINUS
  | TIMES
  | DIVIDE
  | MOD
  | PPLUS
  | PMINUS
  | LOGICAND
  | LOGICOR
  | LOGICXOR
  | LOGICNOT
  | BITOR
  | BITAND
  | BITXOR
  | SHIFTLEFT
  | SHIFTRIGHT
  | UMINUS
  | AMPERSAND
  | BITNOT
  | LOGICEQ
  | LOGICNOTEQ
  | LOGICLESS
  | LOGICLESSEQ
  | LOGICMORE
  | LOGICMOREEQ
  | PLOGICEQ
  | PLOGICNOTEQ
  | ASSIGN
  | PLUSASSIGN
  | MINUSASSIGN
  | TIMESASSIGN
  | DIVIDEASSIGN
  | MODASSIGN
  | COMMA
  | SEMICOL
  | RARROW
  | DOT
  | COLON
  | INTEGER
  | BOOL
  | ALLOC
  | OFFSET
  | SIZE
  | IF
  | ELSE
  | FOR
  | WHILE
  | RETURN
  | TRUE
  | FALSE
  | NULL
  | VAR
  | STRUCT
  | VOID
  | FOREIGN
  | CONTINUE
  | BREAK
  | EOF

val program :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Absyn.program
