(* errormsg.mli *)
(* 15-411 *)
(* by Benjamin Vernot, Peter Lee, Roland Flury *)
(* @version $Id: errormsg.mli,v 1.4 2003/08/28 20:25:33 rflury Exp $ *)

exception EXIT

type pos = (int * int)

(* debug printing *)
val debug : bool ref 

val warningFlag : bool ref

val showProgressFlag : bool ref

val optimizationLevel : int ref

(* Print a message to show the progress in the compilation process *)
val showProgress : string -> unit

val print_debug : string -> unit

(* Initialize current-struct mainly with file-name *)
val startFile : string -> unit

(* Called for each newline *)
val startNewline : int -> unit

(* Called when a new file is scanned *)
val startNewFile : int -> string -> int -> unit 

(* Retrieve file-name and line-number of a position *)
val pos2info : pos -> (string * int)

(* Error msg to user *)
val error : pos -> string -> unit
val warning : pos -> string -> unit
val compiler : pos -> int -> string -> unit
