module type LATTICE =
sig
  type t

  val top : t
  val bot : t

  val meet : t -> t -> t
  val join : t -> t -> t

  val diff : t -> t -> t

  val meet_list : t list -> t
  val join_list : t list -> t

  val equal : t -> t -> bool
  val leq : t -> t -> bool 
end

module type ANALYSIS =
sig
  type info
  type output

  type cfg = CFG.t
  type node = CFG.node

  module MakeFlow (X : sig val cfg : CFG.t end) :
    sig 
      module Lattice : LATTICE 

      val combine : Lattice.t -> Lattice.t -> Lattice.t
      val combine_list : Lattice.t list -> Lattice.t

      val entry : node
      val prev : node -> node list
      val next : node -> node list

      val initial : Lattice.t
      val gen : node -> Lattice.t
      val kill : node -> Lattice.t

      val interpret : Lattice.t -> info
      val interpret' : info CFG.NodeMap.t * info CFG.NodeMap.t -> output
    end
end

