open Sigs 

type definition = Util.definition = {
  label: CFG.node;
  instr: int; (* Instruction # in its block, 0-indexed including label  *)
  assign_var: Temp.temp;
  assign_exp: Ir.exp;
}

val string_of_definition : definition -> string

module Analysis : ANALYSIS with type info = Util.DefinitionSet.t
                            and type output = Util.DefinitionSet.t Util.InstrMap.t
                                            * Util.DefinitionSet.t Util.InstrMap.t

module DFA : sig
  val analyze : CFG.t -> (Analysis.info Util.InstrMap.t *
                          Analysis.info Util.InstrMap.t)
end
