module TempSet = Util.TempSet
module InstrMap = Util.InstrMap

let live live_out_temps stmt =
    match stmt with
    (* "t := e" is live if t is live out or e has effects -wjl *)
    | Ir.MOVE (Ir.TEMP t, e) -> TempSet.mem t live_out_temps || Util.impure e
                                || Temp.reserved t (* or t is reserved *)
    (* | Ir.EXP e -> Util.impure e *)
    | Ir.EXP _
    | Ir.MOVE (_, _)
    | Ir.LABEL _
    | Ir.JUMP _
    | Ir.CJUMP (_, _, _, _, _)
    | Ir.COMMENT (_, _)
    | Ir.INVARIANT _ -> true
    | Ir.SEQ (_, _) -> assert false

let (@@) imap i = InstrMap.find i imap

let eliminate_block label block outflow =
    Util.filteri (fun i stmt -> live (outflow @@ (label, i)) stmt) block

let eliminate nodeblocks ~outflow =
    List.map
        (fun (label, block) -> eliminate_block label block outflow)
        nodeblocks
