module EMap = Aexp.ExpMap
module TempSet = Aexp.TempSet

module T = Ir

(* code duplication :( *)
let rec freetemps exp = 
  match exp with
  | T.TEMP l -> TempSet.singleton l
  | T.MEM e -> freetemps e
  | T.BINOP(op, e1, e2) -> TempSet.union (freetemps e1) (freetemps e2)
  | T.CALL(f, args) ->
      (List.fold_right
	 (fun e set -> TempSet.union (freetemps e) set)
	 args
	 TempSet.empty)
  | T.CONST _ | T.NAME _ -> TempSet.empty
  | T.ESEQ(_, _) | T.PHI _ -> assert false (* not implemented *)

let cse_exp map exp =
  try
    T.TEMP (EMap.find exp map)
  with
    Not_found -> exp

let cse_stmt stmt map =
  let cse exp = cse_exp map exp in
  match stmt with
  | T.MOVE(tgt, e) -> T.MOVE(tgt, cse e)
  | T.EXP e -> T.EXP (cse e)
  | T.CJUMP(relop, e1, e2, lt, lf)  -> T.CJUMP(relop, cse e1, cse e2, lt, lf)
  | T.SEQ(_, _) | T.INVARIANT _ -> assert false
  | other -> stmt
      
let extend_map stmt map =
  match stmt with
  | T.MOVE(T.TEMP t, (T.BINOP(_, e1, e2) as e)) ->
      if TempSet.mem t (TempSet.union (freetemps e1) (freetemps e2)) then
	EMap.remove e map
      else
	EMap.add e t map
  | _ -> map

let rec cse_block inflow block =
  match block with
  | [] -> []
  | stmt :: rest ->
      let stmt = cse_stmt stmt inflow in
      let inflow = extend_map stmt inflow in
      stmt :: (cse_block inflow rest)

let cse node_blocks ~inflow =
  List.map
    (fun (node, block) ->
       let map = CFG.NodeMap.find node inflow in
	 cse_block map block)
    node_blocks

