type t

exception Bitset

val top : int -> t

val bot : int -> t

val make : int -> (int -> bool) -> t

val get : t -> int -> bool

val size : t -> int

val fold : (int -> bool -> 'a -> 'a) -> 'a -> t -> 'a

val intersect : t -> t -> t
val union : t -> t -> t

val intersect_list : int -> t list -> t

val union_list : int -> t list -> t

val print : Format.formatter -> t -> unit

module BV (Size : sig val n : int end) : (Sigs.LATTICE with type t = t)
