open Sigs

module TempSet : Set.S with type elt = Temp.temp
module TempMap : Map.S with type key = Temp.temp

type aexp = {
  label: CFG.node;
  instr: int;
  lhs: Temp.temp;
  expr: Ir.exp;
  freevars: TempSet.t;
}

module AexpSet : Set.S with type elt = aexp
module AexpMap : Map.S with type key = aexp

module ExpMap : Map.S with type key = Ir.exp

module Analysis : ANALYSIS with type info = Temp.temp ExpMap.t
                            and type output = Temp.temp ExpMap.t CFG.NodeMap.t
                                            * Temp.temp ExpMap.t CFG.NodeMap.t

module DFA : sig
  val analyze : CFG.t -> (Analysis.info CFG.NodeMap.t *
			  Analysis.info CFG.NodeMap.t)
end

