type t
type node

val string_of_node : node -> string

module NodeMap : Map.S with type key = node
module NodeSet : Set.S with type elt = node

module NodePairMap : Map.S with type key = node * node
module NodePairSet : Set.S with type elt = node * node


(* [initial_nodemap cfg x] is the NodeMap with each node initialized to x *)
val initial_nodemap : t -> 'a -> 'a NodeMap.t

val make : Ir.stmt list list -> t

val pred : t -> node -> node list
val succ : t -> node -> node list
val code : t -> node -> Ir.stmt list
val nodes : t -> NodeSet.t
val entry : t -> node
val exit : t -> node

val dfs : t -> node list
val bfs : t -> node list

val label : node -> Temp.label

val all_blocks : t -> node list

val bblock_fold :
  (name:node -> targets:node list -> Ir.stmt list -> 'a -> 'a) -> 'a
  -> t -> 'a

val print : string -> t -> unit
