(* Create the command-line given the file-name (infile) and a list of 
 * options (cppFlagList) that are passed to cpp *)
let cpp_commandLine infile cppFlagList = 
  "cpp -C -E -o " ^ !infile ^ ".cpp " ^ 
  (List.fold_left (fun r s -> r ^ s ^ " ") 
     "" !cppFlagList) ^ " " ^ !infile  


(* Create the command-line for calling gcc *)
let gcc_commandLine outfile outfile_exe gccFlagList = 
  "gcc " ^ !outfile ^ 
  " -o " ^ !outfile_exe ^ 
  (List.fold_left (fun r s -> r ^ " " ^ s) 
     "" !gccFlagList)

