(* checker.mli *)
(* 15-411 *)
(* by Roland Flury *)
(* @version $Id: checker.mli,v 1.2 2003/08/11 13:04:42 rflury Exp $ *)

exception CheckerError of string
exception EXIT

(* Prototype of a function *)
type funType = Absyn.ctype * (string * Absyn.ctype) list

(* Description of the fields of a struct *)
type structType = (string * Absyn.ctype) list

(* Translation from  typ to ctype *)
val typ2ctype : Absyn.typ -> Absyn.ctype

(* Returns the type of an expression *)
val ctypeOfExp : Absyn.exp -> Absyn.ctype

(* Returns the type of an L-Value *)
val ctypeOfLval : Absyn.lval -> Absyn.ctype

(* Returns a string representation of a ctype *)
val ctype2string : Absyn.ctype -> string

(* Returns the struct declaration given a struct Name *)
val getStructType : string -> structType

(* Returns the function declaration given a function Name *)
val getFunType : string -> funType

(* Allows to set a fun-type; used for calls to system-functions *)
val setFunType : string -> funType -> unit

(* Type-check a program *)
val check : Absyn.program -> Absyn.program

