(* canon.mli *)
(* 15-411 *)
(* by Roland Flury *)
(* @version $Id: canon.mli,v 1.3 2003/08/28 20:25:33 rflury Exp $ *)

(* linearizes a program produced by translate *)
val linearize : (string * Ir.stmt) list -> (string * Ir.stmt list) list

(* tripleizes a program produced by linearize (triple = three address code) *)
val tripleize : (string * Ir.stmt list) list -> (string * Ir.stmt list) list

(* Transforms the statement lists of functions to basic blocks *)
val basicBlocks : (string * Ir.stmt list) list -> 
  (string * (Ir.stmt list * bool ref) list) list

(* Traces the basic blocks *)
val traceSchedule : (string * (Ir.stmt list * bool ref) list) list -> 
  (string * Ir.stmt list list) list


(* The same as basicBlocks, but only applied to a body of one function *)
val bBlocks : Ir.stmt list -> (Ir.stmt list * bool ref) list

(* Same as traceSchedule, but only applied to a body of one function *)
val trace : (Ir.stmt list * bool ref) list -> Ir.stmt list list

(* God hates you, Roland Flury *)
val with_fname : string -> (unit -> 'a) -> 'a
