(* assem.ml *)
(* 15-411 *)
(* by Roland Flury *)
(* @version $Id: assem.ml,v 1.2 2003/08/11 13:04:42 rflury Exp $ *)

module TP = Temp

type temp = TP.temp
type label = TP.label
      
type instr = 
  | OPER of (string * temp list * temp list * label list)
	(* asscode - src - dst - labels *)
  | LABEL of (string * label)
  | MOVE of (string * temp * temp)
	(* asscode - src - dst *)

(* Returns the list of destinations used in this instruction *)
let getDst = function
  | OPER(_,_,d,_) -> d
  | LABEL(_,_) -> []
  | MOVE(_,_,d) -> [d]

(* Returns the list of sources used in this instruction *)
let getSrc = function
  | OPER(_,s,_,_) -> s
  | LABEL(_,_) -> []
  | MOVE(_,s,_) -> [s]

(* Returns the list of labels used in this instruction *)
let getLabels = function
  | OPER(_,_,_,l) -> l
  | LABEL(_,l) -> [l]
  | MOVE(_,_,_) -> []

(* Returns the string representing the instruction *)
let getAssem = function 
  | OPER(s,_,_,_) -> s
  | LABEL(s,_) -> s
  | MOVE(s,_,_) -> s

(* Returns a string representation of the instruction, using
 * a function mapping temps to a string *)
let format (map: temp->string->string) (invar2str: label->string) instr = 
  let str = ref (getAssem instr) in
  let rec replace token list count = 
    match list with
    | head :: tail -> 
	let tok = token ^ (string_of_int count) in
	let r = Str.regexp tok in
	(match token with
	| "'l" -> 
	    str := Str.global_replace r (TP.label2string head) !str;
	| "'s" -> (* must use %cl for sarl|sall *)
	    str := Str.global_replace r (map head !str) !str;
	| _ -> 
	    str := Str.global_replace r (map head "") !str;
	);
	replace token tail (count + 1);
    | [] -> () 
  in
  replace "'s" (getSrc instr) 0;
  replace "'d" (getDst instr) 0;
  replace "'l" (getLabels instr) 0;
  match instr with
  | OPER(_) -> "\t" ^ !str ^ "\n"
  | MOVE(_) -> "\t" ^ !str ^ "\n"
  | LABEL(_,l) -> !str ^ "\n" ^ (invar2str l)
	
	
