#include "c0vm.h"

#ifndef _C0VM_NATIVES_H
#define _C0VM_NATIVES_H

/* native_fn: the type of generic native functions taking
 *            a variable-length array of generic arguments */
typedef c0_value (*native_fn)(c0_value *);

#define NATIVE_FUNCTION_COUNT 74
extern native_fn native_function_table[NATIVE_FUNCTION_COUNT];

/* conio */
#define NATIVE_PRINT                        0
#define NATIVE_PRINTLN                      1
#define NATIVE_PRINTINT                     2
#define NATIVE_PRINTBOOL                    3
#define NATIVE_PRINTCHAR                    4
#define NATIVE_READLINE                     5
#define NATIVE_ERROR                        6

/* string */
#define NATIVE_STRING_LENGTH                7
#define NATIVE_STRING_CHARAT                8
#define NATIVE_STRING_JOIN                  9
#define NATIVE_STRING_SUB                   10
#define NATIVE_STRING_EQUAL                 11
#define NATIVE_STRING_COMPARE               12
#define NATIVE_STRING_FROMBOOL              13
#define NATIVE_STRING_FROMINT               14
#define NATIVE_STRING_FROMCHAR              15
#define NATIVE_STRING_TOLOWER               16
#define NATIVE_STRING_TO_CHARARRAY          17
#define NATIVE_STRING_FROM_CHARARRAY        18
#define NATIVE_CHAR_ORD                     19
#define NATIVE_CHAR_CHR                     20

/* file */
#define NATIVE_FILE_READ                    21
#define NATIVE_FILE_CLOSE                   22
#define NATIVE_FILE_EOF                     23
#define NATIVE_FILE_READLINE                24

/* parse */
#define NATIVE_PARSE_BOOL                   25
#define NATIVE_PARSE_INT                    26

/* args */
#define NATIVE_ARGS_FLAG                    27
#define NATIVE_ARGS_INT                     28
#define NATIVE_ARGS_STRING                  29
#define NATIVE_ARGS_PARSE                   30

/* abort */
#define NATIVE_C0_ABORT                     31

/* curses */
#define NATIVE_C_INITSCR                    32
#define NATIVE_C_CBREAK                     33
#define NATIVE_C_NOECHO                     34
#define NATIVE_C_KEYPAD                     35
#define NATIVE_C_GETCH                      36
#define NATIVE_C_ADDCH                      37
#define NATIVE_C_WADDCH                     38
#define NATIVE_C_WADDSTR                    39
#define NATIVE_C_WSTANDOUT                  40
#define NATIVE_C_WSTANDEND                  41
#define NATIVE_C_DELCH                      42
#define NATIVE_C_ERASE                      43
#define NATIVE_C_WERASE                     44
#define NATIVE_C_WCLEAR                     45
#define NATIVE_C_MOVE                       46
#define NATIVE_C_WMOVE                      47
#define NATIVE_C_REFRESH                    48
#define NATIVE_C_WREFRESH                   49
#define NATIVE_C_ENDWIN                     50
#define NATIVE_C_CURS_SET                   51
#define NATIVE_C_SUBWIN                     52
#define NATIVE_CC_WBOLDON                   53
#define NATIVE_CC_WBOLDOFF                  54
#define NATIVE_CC_WDIMON                    55
#define NATIVE_CC_WDIMOFF                   56
#define NATIVE_CC_WREVERSEON                57
#define NATIVE_CC_WREVERSEOFF               58
#define NATIVE_CC_WUNDERON                  59
#define NATIVE_CC_WUNDEROFF                 60
#define NATIVE_CC_HIGHLIGHT                 61
#define NATIVE_CC_GETX                      62
#define NATIVE_CC_GETY                      63
#define NATIVE_CC_GETMAXX                   64
#define NATIVE_CC_GETMAXY                   65
#define NATIVE_CC_GETBEGX                   66
#define NATIVE_CC_GETBEGY                   67
#define NATIVE_CC_KEY_IS_ENTER              68
#define NATIVE_CC_KEY_IS_BACKSPACE          69
#define NATIVE_CC_KEY_IS_LEFT               70
#define NATIVE_CC_KEY_IS_RIGHT              71
#define NATIVE_CC_KEY_IS_UP                 72
#define NATIVE_CC_KEY_IS_DOWN               73

#endif /* _C0VM_NATIVES_H */
