#!/usr/bin/perl
$minisat = "~/minisat/core/minisat";
$ok = 1;
if ($#ARGV < 0) {
    print "Usage: ./test.pl solver\n";
    print "where solver is your executable, e.g., \"./solver\" or \"'python solver.py'\".\n";
    exit 1;
}

# Check for existance of MiniSAT.
$gorf = `echo $minisat`; chomp $gorf;
if (not (-e $gorf)) {die("MiniSat executable '$minisat' not found!\n");}

$solver = $ARGV[0];
foreach $bench (<bench*.puz>) {
    $bench =~ s/.puz//;
    if (-e "$bench.out") {`rm $bench.out`;}
    if (-e "$bench.out") {die("Unable to remove $bench.out!\n");}
    if (system("/usr/bin/time -f '$bench: %U sec' bash -c '$solver $bench.puz $bench.out $minisat TempToSat TempFromSat &> errlog.tmp'") != 0) {
        print(`cat errlog.tmp`);
        if ($solver =~ m/^[^.][^ ]*$/) {
            die("Perhaps try './$solver' instead of '$solver'?\n");
        }
        die("Fail.\n");
    }
    if (length(`diff -Bb $bench.out $bench.sol`) > 0) {
        print "Failed benchmark $bench.puz.\n";
        $ok = 0;
    }
}
print "\n";
if ($ok) {print "Success!\n";}
