/*****************************************************************************
* [Your name]
* CS 15-745
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include <vector>

#define foreach(var, container) \
  for (typeof((container).begin()) var = (container).begin(); \
       var != (container).end();  ++var)

using namespace std;

typedef vector<int> IntVec;


/* For debugging: */
void dump(IntVec vec) {
    foreach (iter, vec) {
        printf("%i ", *iter);
    }
    printf("\n");
}

int die(const char* msg) {
    fprintf(stderr, "%s\n", msg);
    exit(1);
}

void SplitInts(const char* pOrigLine, IntVec *pRow) {
    char* pLine = strdup(pOrigLine);
    while (pLine != NULL) {
        char* pTok = strsep(&pLine, " ");
        if (strspn(pTok, "-0123456789") == 0) continue;
        pRow->push_back(atoi(pTok));
    }
}
    
int main(int argc, char **argv) {
    if (argc < 6) {die("Too few args!");}
    FILE* InPuz     = fopen(argv[1], "r");
    FILE* OutSol    = fopen(argv[2], "w");
    char* NameSatExec =     argv[3];
    char* NameTempA =       argv[4];
    char* NameTempB =       argv[5];

    /* Read the puzzle file. */
    vector<IntVec> board;
    char* pLine = NULL;
    size_t BufrLen = 0;
    while (true) {
        if (getline(&pLine, &BufrLen, InPuz) == -1) break;
        IntVec row;
        SplitInts(pLine, &row);
        board.push_back(row);
    }
    uint bsize = board.size();
    foreach (iter, board) {
        assert((*iter).size() == bsize);
    }
    
    /* Write the SAT problem. */
    FILE* TempA = fopen(NameTempA, "w");
    /* TODO: Delete the below dummy statement and write the code to generate
     * a CNF encoding of the Sudoku puzzle in DIMACS format. */
    fprintf(TempA, "%s", 
       "p cnf 4 5\n"
       "1 0 \n"
       "2 -3 0\n"
       "-4 -1 0\n"
       "-1 -2 3 4 0\n"
       "-2 4 0\n"
    );
    fclose(TempA);
    
    /* Execute MiniSAT. */
    char* pSatCmd;
    asprintf(&pSatCmd, "bash -c '%s %s %s &> minisat.log'", 
        NameSatExec, NameTempA, NameTempB);
    remove(NameTempB)==0 || errno==ENOENT || die("Can't remove temp file!");
    system(pSatCmd);
    
    /* Read the solution generated by MiniSAT. */
    FILE* TempB = fopen(NameTempB, "r");
    if (TempB == NULL) {
        fprintf(stderr, "No output file from MiniSAT!\n");
        system("cat minisat.log");
        exit(1);
    }
    getline(&pLine, &BufrLen, TempB);
    if (strncmp(pLine, "SAT", 3) != 0) {die("Unsatisfiable!");}
    getline(&pLine, &BufrLen, TempB);
    IntVec SolnVals;
    SplitInts(pLine, &SolnVals);
    /* TODO: Delete below dummy stmt and update the board based on MiniSAT results. */
    fprintf(stderr, "MiniSat results: "); dump(SolnVals);

    /* Write the solution. */
    foreach (RowIter, board) {
        foreach (CellIter, *RowIter) {
            fprintf(OutSol, "%i ", *CellIter);
        }
        fprintf(OutSol, "\n");
    }
    fclose(OutSol);

    return 0;
}
