/* simplegraph.h */
#ifndef __SIMPLE_GRAPH_H
#define __SIMPLE_GRAPH_H

#include "parameters.h"

typedef int NodeKey;
typedef int NodeData;
typedef int NodeMark;
typedef int EdgeKey;
typedef int EdgeData;
typedef int EdgeMark;

typedef struct Node_T {
	int serial;
	NodeKey nodeKey;
	NodeData nodeData;
	NodeMark nodeMark;

	struct Edge_T* pEdges;

#ifdef PAD_SIMPLE_NODES
	int temp[PAD_SIMPLE_NODES];
#endif
} Node;

typedef struct Edge_T {
	EdgeKey edgeKey;
	EdgeData edgeData;
	EdgeMark edgeMark;

	struct Node_T* pTarget;
	struct Edge_T* pNext;

#ifdef PAD_SIMPLE_EDGES
        int temp[PAD_SIMPLE_EDGES];
#endif
} Edge;

Node* createNode(NodeKey key, NodeData data);

/*
Creates a directed edge from source to target. Edge is attached to source
Returns 0 for success, -1 otherwise
*/
int connectNodes(Node* source, Node* target, EdgeKey key, EdgeData data);

int* refNodeKey (Node* node);
int* refNodeData (Node* node);
int* refNodeMark (Node* node);

#endif
