/* simplegraph.c */

#include "simplegraph.h"
#include <stdio.h>
#include <stdlib.h>

Node* createNode(NodeKey key, NodeData data)
{
	Node* result;
	
	result = (Node*)malloc(sizeof(Node));
	result->nodeKey = key;
	result->serial = -1;
	result->nodeData = data;
	result->pEdges = NULL;
	result->nodeMark = 0;
	return result;
}

/*
Creates a directed edge from source to target. Edge is attached to source
Returns 0 for success, -1 otherwise
*/
int connectNodes(Node* source, Node* target, EdgeKey key, EdgeData data)
{
	Edge* pNewEdge;
	Edge* cur;

	if(source==NULL)
		return -1;
	
	pNewEdge = (Edge*)malloc(sizeof(Edge));
	pNewEdge->edgeKey = key;
	pNewEdge->edgeData = data;
	pNewEdge->pTarget = target;
	pNewEdge->edgeMark = 0;
	
					
	if(source->pEdges==NULL)
	{
		source->pEdges = pNewEdge;
		return 0;
	}
	
	cur = source->pEdges;
	
	while(cur!=NULL)
	{
		if(cur->pNext==NULL)
		{
			cur->pNext = pNewEdge;
			return 0;
		}
		cur = cur->pNext;
	}
			
	return -1;
}


int* refNodeKey (Node* node)
{
	return &node->nodeKey;
}


int* refNodeData (Node* node)
{
	return &node->nodeData;
}

int* refNodeMark (Node* node)
{
	return &node->nodeMark;
}


/*
Obtain reference to next edge for node. Gets last edge for getting next (NULL first time)
Returns null if no next edge
*/


