/*
 *  parameters.h
 *
 * Various parameters

*/

#ifndef __PARAMETERS_H
#define __PARAMETERS_H
/*
#define NO_LOCALITY 1
*/
//#define PRINT_SIZE 1

/* ================================ PARAMETERS YOU CAN CHANGE ================== */
/* ======= Parameters for both graph implementations ======= */
/* Extra cache lines to pad each object with */
#define PAD_LINES 8*1

/* ======== Parameters for the simple graph ======= */
/* Disable these to make them 0, don't just change to 0 ! */


#ifdef NO_LOCALITY
#define PAD_SIMPLE_NODES 3+PAD_LINES
#define PAD_SIMPLE_EDGES 3+PAD_LINES
#endif


/* ========= Paramters for the optimized graph ========= */
/* --- How much padding to add after the first node before first edge --- */

#ifdef NO_LOCALITY
#define OPTIMIZED_NODE_PADDING 3+PAD_LINES
#else
#define OPTIMIZED_NODE_PADDING 0
#endif

/* --- How much padding to add after each edge --- */
#ifdef NO_LOCALITY
#define OPTIMIZED_EDGE_PADDING 4+PAD_LINES
#else
#define OPTIMIZED_EDGE_PADDING 0
#endif

/* --- Keep the following defined if you want to see a printout of every node */
/*
#define PRT_OPTIMIZED_NODE 1
*/

/* ======== Parameters for the test =======*/

/* --- Define PRT if you want to get counts on DFS and BFS. Used for sanity checking of tests --- */
/*
#define PRT 1
*/
/* --- Number of nodes --- */
#define NUMNODES 10000
#define ENRATIO 12

/* --- Number of extra random edges (we will have one per node in addition to these) --- */
#define NUMEDGES ((ENRATIO-1)*NUMNODES)

/* --- Define a worklist size... Not sure how much this should be (for BFS/DFS) but we'll crash if it's not enough --- */
#define WORKLIST_SIZE (NUMEDGES*3)

/* --- Number of times to run the test --- */
#define NUM_RUNS 1000

/* --- Makes the MARK method work only on nodes. Do not run other algorithms if 1 ! */
#define MARK_ONLY_NODES 0

/* --- Flags for running BFS or DFS. Don't have both as 1 ! --- */
#define RUN_BFS 0
#define RUN_DFS 1
#define RUN_ASTAR 0




/* ================================ PARAMTERS YOU SHOULD NOT CHANGE =========== */





/* ========= Paramters for the optimized graph ========= */
#define NODE_DATA_FIELDS 3
#define EDGE_DATA_FIELDS 3
#define EDGES_OFFSET (5+OPTIMIZED_NODE_PADDING)
#define EDGE_SIZE (4+OPTIMIZED_EDGE_PADDING)
#define OFFSET_SERIAL 0
#define OFFSET_NODEKEY 1
#define OFFSET_NODEDATA 2
#define OFFSET_NODEMARK 3
#define OFFSET_NUMEDGES 4
#define OFFSET_EDGEKEY(i) (EDGES_OFFSET + (i)*EDGE_SIZE + 0)
#define OFFSET_EDGEDATA(i) (EDGES_OFFSET + (i)*EDGE_SIZE + 1)
#define OFFSET_EDGEMARK(i) (EDGES_OFFSET + (i)*EDGE_SIZE + 2)
#define OFFSET_EDGETARGET(i) (EDGES_OFFSET + (i)*EDGE_SIZE + 3)


#endif

