/* OptimizedGraph.c*/

#include<stdlib.h>
#include<stdio.h>

#include "optimizedgraph.h"


/*
Creates an ONode from a node
*/
ONode createONodeFromNode(Node* original)
{
	int i=0;
	int sizeInInts;
	int numEdges=0;
	Edge* cur;
	int* result;

	/* Count number of edges */
	cur=original->pEdges;
	while(cur!=NULL)
	{
		numEdges++;
		cur = cur->pNext;
	}
	
	/* Calculate size in Ints */
	sizeInInts = EDGES_OFFSET + (EDGE_SIZE)*numEdges;
	
	/*
	printf("There are %d edges which result in a size in ints of %d\n", numEdges, sizeInInts);
	*/
	
	/* Allocate */
	result = (int*)malloc(sizeInInts*sizeof(int));
#ifdef PRINT_SIZE
	printf("Allocated size for optimized node with %d edges is %ld bytes\n",numEdges,sizeInInts*sizeof(int));
#endif
	/* Copy fields */

	
	result[OFFSET_SERIAL] = original->serial;
	result[OFFSET_NODEKEY] = original->nodeKey;
	result[OFFSET_NODEDATA] = original->nodeData;
	result[OFFSET_NODEMARK] = original->nodeMark;
	result[OFFSET_NUMEDGES] = numEdges;
	cur=original->pEdges;
	
	i=0;
	while(cur!=NULL)
	{
		result[OFFSET_EDGEKEY(i)] = cur->edgeKey;
		result[OFFSET_EDGEDATA(i)] = cur->edgeData;
		result[OFFSET_EDGEMARK(i)] = cur->edgeMark;
		result[OFFSET_EDGETARGET(i)] = cur->pTarget->serial;
		++i;
		cur = cur->pNext;
	}

#ifdef PRT_OPTIMIZED_NODE
	for(i=0; i<sizeInInts; ++i)
	{
		printf(" %d ",result[i]);
	}
	printf("\n");
#endif
	return result;
}

/*
Optimize an existing graph
*/
ONode* optimizeSimpleGraph(Node** arOriginalGraph, int numNodes)
{
	ONode* arNewGraph;
	int i;
	
	/* Allocate array for pointers to optimized nodes */
	arNewGraph = (ONode*)malloc(numNodes*sizeof(ONode));
	
	/* Now start going over the graph */
	for(i=0; i<numNodes; ++i)
	{
		Node* pOrig;
		ONode newNode;
		
		pOrig = arOriginalGraph[i];
		newNode = createONodeFromNode(pOrig);
		
		arNewGraph[i] = newNode;
	}
	
	
	return arNewGraph;
}
