/* mst.c */
/* build a maximal spanning tree of edges in the graph */

#include <glib.h>
#include "gpriq.h"

#include "simplegraph.h"
#include "optimizedgraph.h"

#define INFINITY 2147483647

/* comparison function used to built heap in the priority queue */
gint compare_int(gconstpointer a, gconstpointer b) {
    return (a < b) ? 1 : ((a == b) ? 0 : -1);
} /* compare_int */

/* insert all vertices in the priority queue */
GPriq* simple_init(Node **graph, int numNodes) {
    int i;
    GPriq *queue;

    queue = g_priq_new(compare_int);
    
    for (i=0; i<numNodes; ++i) {
	Node *node;

	node = graph[i];

	/* insert the node in the queue */
	if (i==0)
	    g_priq_insert(queue, 0, node);
	else
	    g_priq_insert(queue, INFINITY, node);
    } /* for */

    return queue;
} /* simple_init */

