/* main.c */
/* Test program for graph algorithms */


#include <stdio.h>
#include <stdlib.h>

#include "parameters.h"

#include "simplegraph.h"
#include "graphloader.h"
#include "optimizedgraph.h"
#include "astar.h"
#include "tests.h"

int main()
{    
    Node** arSimpleGraph;
    ONode* arOptimizedGraph;      
    
	printf("Running experiment for NUMNODES: %D, ENRATIO: %d, RUNS: %d, ONLY_NODES: %d\n",NUMNODES,ENRATIO,NUM_RUNS,MARK_ONLY_NODES);
#ifdef NO_LOCALITY
	printf("RUNNING WITHOUT LOCALITY!\n");
#else
	printf("RUNNING WITH LOCALITY\n");
#endif

	printf("Size of int: %d, sizeof int*: %d, size of Node: %d, size of Edge: %d, sizeof ONode %d\n", sizeof(int),sizeof(int*),sizeof(Node),sizeof(Edge),sizeof(ONode)); 
	
    printf("Started\n");
    
    //arSimpleGraph = loadGraph("graph.dat");
    printf("Generating random graph\n");
    arSimpleGraph = generateRandomGraph(NUMNODES, NUMEDGES);
    printf("Done generating random graph\n");
    
    // Create optimized graph
    printf("Creating optimized graph\n");
    arOptimizedGraph = optimizeSimpleGraph(arSimpleGraph, NUMNODES);
    printf("Done creating optimized graph\n");
    
    runTests(arSimpleGraph, arOptimizedGraph, NUMNODES);
      
    printf("Ended\n");

#ifdef E_ASTAR
    /* test code for A* search functions
    Node **graph;
    ONode *ograph1, *ograph2, *ograph3;
    int i;
    
    // create a small "simple" graph
    graph = calloc(10, sizeof(Node*));

    for (i=0; i<10; ++i) {
	graph[i] = createNode(0, 0);
	graph[i]->serial = i;
    } // for
    
    // 1: connect three nodes in a line 0-1-2
    connectNodes(graph[0], graph[1], 0, 0);
    connectNodes(graph[1], graph[2], 0, 0);
    
    ograph1 = optimizeSimpleGraph(graph, 10);

    printf("*** 0-1-2 Simple ***\n");
    find_path_simple(graph, 10, graph[0], graph[2]);
    printf("*** 0-1-2 Opt ***\n");
    find_path_opt(ograph1, 10, ograph1[0], ograph1[2]);
    
    // 2: add another connect from 0 to 2
    connectNodes(graph[0], graph[2], 0, 0);
    ograph2 = optimizeSimpleGraph(graph, 10);
    
    printf("*** 0-1-2, 0-2 Simple ***\n");
    find_path_simple(graph, 10, graph[0], graph[2]);
    printf("*** 0-1-2, 0-2 Opt ***\n");
    find_path_opt(ograph2, 10, ograph2[0], ograph2[2]);
    
    // 3: add a couple more nodes, 0-1-2-3-4, with 0->2, and 1->4
    connectNodes(graph[2], graph[3], 0, 0);
    connectNodes(graph[3], graph[4], 0, 0);
    connectNodes(graph[1], graph[4], 0, 0);
    ograph3 = optimizeSimpleGraph(graph, 10);
    
    printf("*** 0-1-2, 0-2, 1-4 Simple ***\n");
    find_path_simple(graph, 10, graph[0], graph[4]);
    printf("*** 0-1-2, 0-2, 1-4 Opt ***\n");
    find_path_opt(ograph3, 10, ograph3[0], ograph3[4]);
    */
#endif
    
      return 0;
}

