/* GraphLoader.c */
#include <stdio.h>
#include <stdlib.h>
#include "graphloader.h"

int getrand(int max)
{
	int orig;
	double tmp;
	int final;
		
	orig = rand();
	tmp = (double)orig / (double)RAND_MAX;
	tmp = max * tmp;
	final = (int)tmp;
	
	return final;
}


/*
Loads a graph from a specially formatted file
Returns it in the form of an array of node pointers
*/
Node** loadGraph(char* filename)
{
	FILE* f;
	int numNodes;
	Node** ar;
	int i;
	
	f = fopen(filename, "r");
	
	/* Read number of nodes */
	fscanf(f,"%d\n",&numNodes);
	printf("There are %d nodes\n",numNodes);
	
	/* Allocate array*/
	ar = malloc(numNodes*sizeof(Node*));
	
	/* Start reading nodes*/
	for(i=0; i<numNodes; ++i)
	{
		Node* newNode;
		int serial;
		int key;
		int data;
		
		fscanf(f, "%d\t%d\t%d\n",&serial, &key,&data);
		printf("[%d] Got key %d data %d\n",serial, key,data);
		newNode = createNode(key, data);
		newNode->serial = i;
		ar[i]=newNode;
	}
	
	/* Now read edges*/
	while(!feof(f))
	{
		int source;
		int target;
		int key;
		int data;
		fscanf(f, "%d\t%d\%d\%d\n",&source, &target, &key, &data);
		printf("Got edge from %d to %d with key %d data %d\n",source,target,key,data);	
		connectNodes(ar[source],ar[target],key,data);
	}
	
	
	
	fclose(f);
	return ar;
}


Node** generateRandomGraph(int numNodes, int numExtraEdges)
{
	Node** ar;
	int i;

	/* Allocate array*/
	ar = malloc(numNodes*sizeof(Node*));
	
	/* Start creating nodes*/
	for(i=0; i<numNodes; ++i)
	{
		Node* newNode;
		int serial;
		int key;
		int data;

		serial = i;
		key = getrand(100);
		data = getrand(200);


	/*
		printf("[%d] Got key %d data %d\n",serial, key,data);
	*/
		
				newNode = createNode(key, data);
				newNode->serial = serial;
		ar[i]=newNode;
	}	



	/* Now create initial edges (1 per line) */
	for(i=0; i<numNodes; ++i)
	{
		int key,data,target;
	
		key = getrand(100);
		data = getrand(200);
		target = getrand(numNodes);
		
		/*
		printf("Created initial edge from %d to %d with key %d data %d\n",i,target,key,data);	
		*/
		connectNodes(ar[i],ar[target],key,data);		
	}
	
	/* Now create other edges */
	for(i=0; i<numExtraEdges; ++i)
	{

		int source;
		int target;
		int key;
		int data;
		key = getrand(100);
		
		data = getrand(200);
		source = getrand(numNodes);
		target = getrand(numNodes);	
	/*
		printf("Created additional edge %d from %d to %d with key %d data %d\n",i, source,target,key,data);	
	*/
		connectNodes(ar[source],ar[target],key,data);
	}	
	
	return ar;

}




/*
Graph writing code */

int writeGraph(char* filename, Node** nodes, int numNodes)
{
	printf("Unimplemented\n");
	return 0;
}
